/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class UUIDFetcher {
    private static final String API_URL = "https://playerdb.co/api/player/minecraft/%s";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable UUID getUUID(@NotNull String name) {
        name = name.toLowerCase();
        try {
            HttpURLConnection connection = (HttpURLConnection)URI.create(String.format(API_URL, name)).toURL().openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            connection.setReadTimeout(5000);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                JsonElement parsed = JsonParser.parseString((String)response.toString());
                if (parsed == null || !parsed.isJsonObject()) {
                    UUID uUID = null;
                    return uUID;
                }
                JsonObject data = parsed.getAsJsonObject();
                UUID uUID = UUID.fromString(data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("id").getAsString());
                return uUID;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

