/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util.teleport;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;

public class ClosestSafeSpotTeleport {
    private static final Comparator<PositionData> POSITION_COMPARATOR = Comparator.comparingDouble(PositionData::distance).thenComparingInt(position -> position.vector().getBlockX()).thenComparingInt(position -> position.vector().getBlockZ()).thenComparingInt(position -> position.vector().getBlockY());
    private static final long CHUNK_LOAD_SPEED = 1L;
    private static final int SCAN_RANGE = 20;
    private final BentoBox plugin;
    private final Entity entity;
    private final Location location;
    private final World world;
    private final Runnable successRunnable;
    private final CompletableFuture<Boolean> result;
    private final boolean portal;
    private final boolean cancelIfFail;
    private final AtomicBoolean checking = new AtomicBoolean();
    private int range;
    private Queue<PositionData> blockQueue;
    private Iterator<Pair<Integer, Integer>> chunksToScanIterator;
    private BoundingBox boundingBox;
    private Location noPortalPosition;
    private BukkitTask task;

    ClosestSafeSpotTeleport(Builder builder) {
        this.plugin = builder.getPlugin();
        this.entity = builder.getEntity();
        this.location = builder.getLocation();
        this.portal = builder.isPortal();
        this.successRunnable = builder.getSuccessRunnable();
        this.result = builder.getResult();
        this.world = Objects.requireNonNull(this.location.getWorld());
        this.cancelIfFail = builder.isCancelIfFail();
        Util.getChunkAtAsync(this.location).thenRun(this::checkLocation);
    }

    void checkLocation() {
        if (!this.portal && this.plugin.getIslandsManager().isSafeLocation(this.location)) {
            this.teleportEntity(this.location);
            return;
        }
        this.boundingBox = this.plugin.getIslandsManager().getIslandAt(this.location).map(Island::getProtectionBoundingBox).orElseGet(() -> {
            double protectionRange = this.plugin.getIWM().getIslandProtectionRange(this.world);
            return new BoundingBox((double)this.location.getBlockX() - protectionRange, Math.max((double)this.world.getMinHeight(), (double)this.location.getBlockY() - protectionRange), (double)this.location.getBlockZ() - protectionRange, (double)this.location.getBlockX() + protectionRange, Math.min((double)this.world.getMaxHeight(), (double)this.location.getBlockY() + protectionRange), (double)this.location.getBlockZ() + protectionRange);
        });
        this.range = Math.min(this.plugin.getSettings().getSafeSpotSearchRange(), (int)this.boundingBox.getWidthX() / 2);
        this.blockQueue = new PriorityQueue<PositionData>(this.range * 2, POSITION_COMPARATOR);
        this.chunksToScanIterator = this.getChunksToScan().iterator();
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::gatherChunks, 0L, 1L);
    }

    void gatherChunks() {
        if (this.checking.get()) {
            return;
        }
        this.checking.set(true);
        if (!this.portal && !this.blockQueue.isEmpty() && this.blockQueue.peek().distance() < 5.0) {
            this.finishTask();
            return;
        }
        if (!this.chunksToScanIterator.hasNext()) {
            this.finishTask();
            return;
        }
        Pair<Integer, Integer> chunkPair = this.chunksToScanIterator.next();
        this.chunksToScanIterator.remove();
        ((CompletableFuture)Util.getChunkAtAsync(Objects.requireNonNull(this.world), (Integer)chunkPair.x, (Integer)chunkPair.z).thenApply(Chunk::getChunkSnapshot)).whenCompleteAsync((snapshot, e) -> {
            if (snapshot != null) {
                this.scanAndPopulateBlockQueue((ChunkSnapshot)snapshot);
            }
            this.checking.set(false);
        });
    }

    List<Pair<Integer, Integer>> getChunksToScan() {
        ArrayList<Pair<Integer, Integer>> chunksToScan = new ArrayList<Pair<Integer, Integer>>();
        int x = this.location.getBlockX();
        int z = this.location.getBlockZ();
        int numberOfChunks = ((x + 20 >> 4) - (x - 20 >> 4) + 1) * ((z + 20 >> 4) - (z - 20 >> 4) + 1);
        int offsetX = 0;
        int offsetZ = 0;
        for (int i = 0; i < numberOfChunks; ++i) {
            int locationX = x + (offsetX << 4);
            int locationZ = z + (offsetZ << 4);
            this.addChunk(chunksToScan, new Pair<Integer, Integer>(locationX, locationZ), new Pair<Integer, Integer>(locationX >> 4, locationZ >> 4));
            if (Math.abs(offsetX) <= Math.abs(offsetZ) && (offsetX != offsetZ || offsetX >= 0)) {
                offsetX += offsetZ >= 0 ? 1 : -1;
                continue;
            }
            offsetZ += offsetX >= 0 ? -1 : 1;
        }
        return chunksToScan;
    }

    void addChunk(List<Pair<Integer, Integer>> chunksToScan, Pair<Integer, Integer> blockCoord, Pair<Integer, Integer> chunkCoord) {
        if (!chunksToScan.contains(chunkCoord) && this.plugin.getIslandsManager().getIslandAt(this.location).map(is -> is.inIslandSpace(blockCoord)).orElse(true).booleanValue()) {
            chunksToScan.add(chunkCoord);
        }
    }

    void scanAndPopulateBlockQueue(ChunkSnapshot chunkSnapshot) {
        int startY = this.location.getBlockY();
        int minY = this.world.getMinHeight();
        int maxY = this.world.getMaxHeight();
        Vector blockVector = new Vector(this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
        int chunkX = chunkSnapshot.getX() << 4;
        int chunkZ = chunkSnapshot.getZ() << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = Math.max(minY, startY - this.range); y < Math.min(maxY, startY + this.range); ++y) {
                    Vector positionVector = new Vector(chunkX + x, y, chunkZ + z);
                    if (!this.boundingBox.contains(positionVector)) continue;
                    PositionData positionData = new PositionData(positionVector, chunkSnapshot.getBlockType(x, y - 1, z), y < maxY ? chunkSnapshot.getBlockType(x, y, z) : null, y + 1 < maxY ? chunkSnapshot.getBlockType(x, y + 1, z) : null, blockVector.distanceSquared(positionVector));
                    if (!this.plugin.getIslandsManager().checkIfSafe(this.world, positionData.block, positionData.spaceOne, positionData.spaceTwo)) continue;
                    this.blockQueue.add(positionData);
                }
            }
        }
    }

    void finishTask() {
        this.task.cancel();
        if (this.scanBlockQueue()) {
            return;
        }
        if (this.portal && this.noPortalPosition != null) {
            this.teleportEntity(this.noPortalPosition);
        } else {
            Entity entity = this.entity;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.returnAndTeleport(player));
            }
        }
        this.result.complete(false);
    }

    void returnAndTeleport(Player player) {
        User.getInstance((CommandSender)this.entity).notify("general.errors.no-safe-location-found", new String[0]);
        Block highestBlock = this.world.getHighestBlockAt(this.location);
        if (highestBlock.getType().isSolid() && this.plugin.getIslandsManager().isSafeLocation(highestBlock.getLocation())) {
            this.asyncTeleport(highestBlock.getLocation().add(new Vector(0.5, 0.0, 0.5)));
        } else if (!this.plugin.getIWM().inWorld(this.entity.getLocation())) {
            player.performCommand("spawn");
        } else if (!this.cancelIfFail) {
            switch (this.world.getEnvironment()) {
                case NETHER: {
                    this.makeAndTeleport(Material.NETHERRACK);
                    break;
                }
                case THE_END: {
                    this.makeAndTeleport(Material.END_STONE);
                    break;
                }
                default: {
                    this.makeAndTeleport(Material.COBBLESTONE);
                }
            }
        }
    }

    void makeAndTeleport(Material baseMaterial) {
        this.location.getBlock().getRelative(BlockFace.DOWN).setType(baseMaterial, false);
        this.location.getBlock().setType(Material.AIR, false);
        this.location.getBlock().getRelative(BlockFace.UP).setType(Material.AIR, false);
        this.location.getBlock().getRelative(BlockFace.UP).getRelative(BlockFace.UP).setType(baseMaterial, false);
        this.asyncTeleport(this.location.clone().add(new Vector(0.5, 0.0, 0.5)));
    }

    boolean scanBlockQueue() {
        boolean blockFound = false;
        while (!this.blockQueue.isEmpty() && !blockFound) {
            blockFound = this.checkPosition(this.blockQueue.poll());
        }
        return blockFound;
    }

    void teleportEntity(Location location) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.asyncTeleport(location));
    }

    void asyncTeleport(Location location) {
        Util.teleportAsync(Objects.requireNonNull(this.entity), Objects.requireNonNull(location)).thenRun(() -> {
            if (this.successRunnable != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, this.successRunnable);
            }
            this.result.complete(true);
        });
    }

    boolean checkPosition(PositionData positionData) {
        if (this.portal) {
            if (Material.NETHER_PORTAL.equals((Object)positionData.spaceOne()) || Material.NETHER_PORTAL.equals((Object)positionData.spaceTwo())) {
                this.teleportEntity(new Location(this.world, (double)positionData.vector().getBlockX() + 0.5, (double)positionData.vector().getBlockY() + 0.1, (double)positionData.vector().getBlockZ() + 0.5, this.location.getYaw(), this.location.getPitch()));
                return true;
            }
            if (this.noPortalPosition == null) {
                this.noPortalPosition = new Location(this.world, (double)positionData.vector().getBlockX() + 0.5, (double)positionData.vector().getBlockY() + 0.1, (double)positionData.vector().getBlockZ() + 0.5, this.location.getYaw(), this.location.getPitch());
            }
        } else {
            this.teleportEntity(new Location(this.world, (double)positionData.vector().getBlockX() + 0.5, (double)positionData.vector().getBlockY() + 0.1, (double)positionData.vector().getBlockZ() + 0.5, this.location.getYaw(), this.location.getPitch()));
            return true;
        }
        return false;
    }

    public static Builder builder(BentoBox plugin) {
        return new Builder(plugin);
    }

    public static class Builder {
        private final BentoBox plugin;
        private final CompletableFuture<Boolean> result;
        private Entity entity;
        private Location location;
        private World world;
        private Runnable successRunnable;
        private boolean portal;
        private boolean cancelIfFail;

        private Builder(BentoBox plugin) {
            this.plugin = plugin;
            this.result = new CompletableFuture();
        }

        public Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder portal() {
            this.portal = true;
            return this;
        }

        public Builder successRunnable(Runnable successRunnable) {
            this.successRunnable = successRunnable;
            return this;
        }

        public @Nullable ClosestSafeSpotTeleport build() {
            if (this.entity == null) {
                this.plugin.logError("Attempt to safe teleport a null entity!");
                this.result.complete(null);
                return null;
            }
            if (this.location == null) {
                this.plugin.logError("Attempt to safe teleport to a null location!");
                this.result.complete(null);
                return null;
            }
            if (this.location.getWorld() == null) {
                this.plugin.logError("Attempt to safe teleport to a null world!");
                this.result.complete(null);
                return null;
            }
            return new ClosestSafeSpotTeleport(this);
        }

        public BentoBox getPlugin() {
            return this.plugin;
        }

        public CompletableFuture<Boolean> getResult() {
            return this.result;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Location getLocation() {
            return this.location;
        }

        public World getWorld() {
            return this.world;
        }

        public Runnable getSuccessRunnable() {
            return this.successRunnable;
        }

        public boolean isPortal() {
            return this.portal;
        }

        public boolean isCancelIfFail() {
            return this.cancelIfFail;
        }
    }

    record PositionData(Vector vector, Material block, Material spaceOne, Material spaceTwo, double distance) {
    }
}

