/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.util.metrics.bukkit.Metrics;
import world.bentobox.bentobox.util.metrics.charts.AdvancedPie;
import world.bentobox.bentobox.util.metrics.charts.SimpleBarChart;
import world.bentobox.bentobox.util.metrics.charts.SimplePie;
import world.bentobox.bentobox.util.metrics.charts.SingleLineChart;

public class BStats {
    private static final int BSTATS_ID = 3555;
    private final BentoBox plugin;
    private Metrics metrics;
    private int islandsCreatedCount = 0;
    private final Set<UUID> connectedPlayerSet = new HashSet<UUID>();

    BStats(BentoBox plugin) {
        this.plugin = plugin;
    }

    void registerMetrics() {
        if (this.metrics == null) {
            this.metrics = new Metrics(this.plugin, 3555);
            this.registerCustomMetrics();
        }
    }

    private void registerCustomMetrics() {
        this.registerDefaultLanguageChart();
        this.registerDatabaseTypeChart();
        this.registerAddonsChart();
        this.registerGameModeAddonsChart();
        this.registerHooksChart();
        this.registerPlayersPerServerChart();
        this.registerIslandsCountChart();
        this.registerIslandsCreatedChart();
        this.registerAddonsBarChart();
        this.registerGameModeAddonsBarChart();
        this.registerHooksBarChart();
    }

    private void registerDefaultLanguageChart() {
        this.metrics.addCustomChart(new SimplePie("default_language", () -> this.plugin.getSettings().getDefaultLanguage()));
    }

    private void registerDatabaseTypeChart() {
        this.metrics.addCustomChart(new SimplePie("database_type", () -> this.plugin.getSettings().getDatabaseType().toString()));
    }

    private void registerIslandsCountChart() {
        this.metrics.addCustomChart(new SingleLineChart("islands", () -> this.plugin.getIslands().getIslandCount()));
    }

    private void registerIslandsCreatedChart() {
        this.metrics.addCustomChart(new SingleLineChart("islandsCreated", () -> {
            int value = this.islandsCreatedCount;
            this.islandsCreatedCount = 0;
            return value;
        }));
    }

    public void increaseIslandsCreatedCount() {
        ++this.islandsCreatedCount;
    }

    public void addPlayer(UUID uuid) {
        this.connectedPlayerSet.add(uuid);
    }

    private void registerAddonsChart() {
        this.metrics.addCustomChart(new AdvancedPie("addons", () -> {
            HashMap values = new HashMap();
            this.plugin.getAddonsManager().getEnabledAddons().stream().filter(addon -> !(addon instanceof GameModeAddon) && addon.getDescription().isMetrics()).forEach(addon -> values.put(addon.getDescription().getName(), 1));
            return values;
        }));
    }

    private void registerGameModeAddonsChart() {
        this.metrics.addCustomChart(new AdvancedPie("gameModeAddons", () -> {
            HashMap values = new HashMap();
            this.plugin.getAddonsManager().getGameModeAddons().stream().filter(gameModeAddon -> gameModeAddon.getDescription().isMetrics()).forEach(gameModeAddon -> values.put(gameModeAddon.getDescription().getName(), 1));
            return values;
        }));
    }

    private void registerHooksChart() {
        this.metrics.addCustomChart(new AdvancedPie("hooks", () -> {
            HashMap values = new HashMap();
            this.plugin.getHooks().getHooks().forEach(hook -> values.put(hook.getPluginName(), 1));
            return values;
        }));
    }

    private void registerPlayersPerServerChart() {
        this.metrics.addCustomChart(new SimplePie("playersPerServer", () -> {
            int players = this.connectedPlayerSet.size();
            this.connectedPlayerSet.clear();
            if (players <= 0) {
                return "0";
            }
            if (players <= 10) {
                return "1-10";
            }
            if (players <= 30) {
                return "11-30";
            }
            if (players <= 50) {
                return "31-50";
            }
            if (players <= 100) {
                return "51-100";
            }
            if (players <= 150) {
                return "101-150";
            }
            if (players <= 200) {
                return "151-200";
            }
            return "201+";
        }));
    }

    private void registerAddonsBarChart() {
        this.metrics.addCustomChart(new SimpleBarChart("addonsBar", () -> {
            HashMap values = new HashMap();
            this.plugin.getAddonsManager().getEnabledAddons().stream().filter(addon -> !(addon instanceof GameModeAddon) && addon.getDescription().isMetrics()).forEach(addon -> values.put(addon.getDescription().getName(), 1));
            return values;
        }));
    }

    private void registerGameModeAddonsBarChart() {
        this.metrics.addCustomChart(new SimpleBarChart("gameModeAddonsBar", () -> {
            HashMap values = new HashMap();
            this.plugin.getAddonsManager().getGameModeAddons().stream().filter(gameModeAddon -> gameModeAddon.getDescription().isMetrics()).forEach(gameModeAddon -> values.put(gameModeAddon.getDescription().getName(), 1));
            return values;
        }));
    }

    private void registerHooksBarChart() {
        this.metrics.addCustomChart(new SimpleBarChart("hooksBar", () -> {
            HashMap values = new HashMap();
            this.plugin.getHooks().getHooks().forEach(hook -> values.put(hook.getPluginName(), 1));
            return values;
        }));
    }
}

