/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.island.IslandGoCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminDeleteCommand
extends ConfirmableCommand {
    private @Nullable UUID targetUUID;
    private Island island;

    public AdminDeleteCommand(CompositeCommand parent) {
        super(parent, "delete", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.delete");
        this.setParametersHelp("commands.admin.delete.parameters");
        this.setDescription("commands.admin.delete.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        String name;
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), this.targetUUID) && !this.getIslands().inTeam(this.getWorld(), this.targetUUID)) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (args.size() == 1) {
            if (this.getIslands().getIslands(this.getWorld(), this.targetUUID).stream().filter(Island::hasTeam).anyMatch(is -> this.targetUUID.equals(is.getOwner()))) {
                user.sendMessage("commands.admin.delete.cannot-delete-owner", new String[0]);
                return false;
            }
            return true;
        }
        User target = User.getInstance(this.targetUUID);
        Map<String, IslandGoCommand.IslandInfo> names = IslandGoCommand.getNameIslandMap(target, this.getWorld());
        if (!names.containsKey(name = String.join((CharSequence)" ", args.subList(1, args.size())))) {
            user.sendMessage("commands.island.go.unknown-home", new String[0]);
            user.sendMessage("commands.island.sethome.homes-are", new String[0]);
            names.keySet().forEach(n -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)n));
            return false;
        }
        IslandGoCommand.IslandInfo info = names.get(name);
        this.island = info.island();
        if (this.island.hasTeam() && this.targetUUID.equals(this.island.getOwner())) {
            user.sendMessage("commands.admin.delete.cannot-delete-owner", new String[0]);
            return false;
        }
        if (names.size() == 1) {
            this.island = null;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.island == null) {
            this.askConfirmation(user, () -> this.deletePlayer(user));
        } else {
            this.askConfirmation(user, () -> this.deleteIsland(user, this.island));
        }
        return true;
    }

    private void deleteIsland(User user, Island oldIsland) {
        IslandEvent.builder().involvedPlayer(user.getUniqueId()).reason(IslandEvent.Reason.PRECLEAR).island(oldIsland).oldIsland(oldIsland).location(oldIsland.getCenter()).build();
        user.sendMessage("commands.admin.delete.deleted-island", "[xyz]", Util.xyz(oldIsland.getCenter().toVector()));
        this.getIslands().deleteIsland(oldIsland, true, this.targetUUID);
    }

    private void deletePlayer(User user) {
        for (Island oldIsland : this.getIslands().getIslands(this.getWorld(), this.targetUUID)) {
            this.deleteIsland(user, oldIsland);
        }
        assert (this.targetUUID != null);
        User target = User.getInstance(this.targetUUID);
        this.getIslands().removePlayer(this.getWorld(), this.targetUUID);
        if (target.isPlayer() && target.isOnline()) {
            this.cleanUp(target);
        }
        user.sendMessage("general.success", new String[0]);
    }

    private void cleanUp(User target) {
        if (this.getIWM().isOnLeaveResetEnderChest(this.getWorld())) {
            target.getPlayer().getEnderChest().clear();
        }
        if (this.getIWM().isOnLeaveResetInventory(this.getWorld())) {
            target.getPlayer().getInventory().clear();
        }
        if (this.getSettings().isUseEconomy() && this.getIWM().isOnLeaveResetMoney(this.getWorld())) {
            this.getPlugin().getVault().ifPresent(vault -> vault.withdraw(target, vault.getBalance(target)));
        }
        if (this.getIWM().isOnLeaveResetHealth(this.getWorld())) {
            Util.resetHealth(target.getPlayer());
        }
        if (this.getIWM().isOnLeaveResetHunger(this.getWorld())) {
            target.getPlayer().setFoodLevel(20);
        }
        if (this.getIWM().isOnLeaveResetXP(this.getWorld())) {
            target.getPlayer().setLevel(0);
            target.getPlayer().setExp(0.0f);
            target.getPlayer().setTotalExperience(0);
        }
        Util.runCommands(target, target.getName(), this.getIWM().getOnLeaveCommands(this.getWorld()), "leave");
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.getLast() : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        if (args.size() == 2) {
            return Optional.of(Util.tabLimit(new ArrayList<String>(Util.getOnlinePlayerList(user)), lastArg));
        }
        if (args.size() == 3) {
            UUID target = Util.getUUID(args.get(1));
            return target == null ? Optional.empty() : Optional.of(Util.tabLimit(new ArrayList<String>(IslandGoCommand.getNameIslandMap(User.getInstance(target), this.getWorld()).keySet()), lastArg));
        }
        return Optional.empty();
    }
}

