/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminDeleteHomesCommand
extends ConfirmableCommand {
    public AdminDeleteHomesCommand(CompositeCommand parent) {
        super(parent, "deletehomes", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.deletehomes");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.deletehomes.parameters");
        this.setDescription("commands.admin.deletehomes.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        UUID targetUUID = Util.getUUID(args.getFirst());
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), targetUUID);
        if (island == null) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        this.askConfirmation(user, user.getTranslation("commands.admin.deletehomes.warning", new String[0]), () -> this.deleteHomes(user, island));
        return true;
    }

    private void deleteHomes(User user, Island island) {
        island.removeHomes();
        user.sendMessage("general.success", new String[0]);
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.getLast() : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

