/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class AdminGetrankCommand
extends CompositeCommand {
    private Island island;
    private @Nullable UUID targetUUID;

    public AdminGetrankCommand(CompositeCommand adminCommand) {
        super(adminCommand, "getrank", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.getrank");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.getrank.parameters");
        this.setDescription("commands.admin.getrank.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1 && args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (args.size() == 1) {
            if (!this.getIslands().hasIsland(this.getWorld(), this.targetUUID) && !this.getIslands().inTeam(this.getWorld(), this.targetUUID)) {
                user.sendMessage("general.errors.player-has-no-island", new String[0]);
                return false;
            }
            this.island = this.getIslands().getIsland(this.getWorld(), this.targetUUID);
        } else {
            @Nullable UUID ownerUUID = this.getPlayers().getUUID(args.get(1));
            if (ownerUUID == null) {
                user.sendMessage("general.errors.unknown-player", "[name]", args.get(1));
                return false;
            }
            if (!this.getPlugin().getIslands().hasIsland(this.getWorld(), ownerUUID)) {
                user.sendMessage("general.errors.player-is-not-owner", "[name]", args.get(1));
                return false;
            }
            this.island = this.getIslands().getIsland(this.getWorld(), ownerUUID);
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        assert (this.targetUUID != null);
        User target = User.getInstance(this.targetUUID);
        int currentRank = this.island.getRank(target);
        user.sendMessage("commands.admin.getrank.rank-is", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(currentRank), new String[0]), "[name]", this.getPlayers().getName(this.island.getOwner()));
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        if (args.isEmpty()) {
            return Optional.empty();
        }
        String lastArg = args.getLast();
        List<String> options = Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

