/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminResetNameCommand
extends CompositeCommand {
    private @Nullable Island island;

    public AdminResetNameCommand(CompositeCommand command) {
        super(command, "resetname", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.resetname");
        this.setOnlyPlayer(true);
        this.setDescription("commands.admin.resetname.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() == 1) {
            UUID playerUUID = Util.getUUID(args.getFirst());
            if (playerUUID == null) {
                user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
                return false;
            }
            this.island = this.getIslandsManager().getIsland(this.getWorld(), playerUUID);
        } else {
            this.island = this.getIslandsManager().getIslandAt(user.getLocation()).orElse(null);
        }
        if (this.island == null) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.island == null) {
            this.showHelp(this, user);
            return true;
        }
        this.island.setName(null);
        user.sendMessage("commands.admin.resetname.success", "[name]", this.getPlayers().getName(this.island.getOwner()));
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        if (args.size() == 1) {
            return Optional.of(Util.getOnlinePlayerList(user));
        }
        return Optional.empty();
    }
}

