/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.World;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class AdminSetSpawnPointCommand
extends ConfirmableCommand {
    public AdminSetSpawnPointCommand(CompositeCommand parent) {
        super(parent, "setspawnpoint", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.setspawnpoint");
        this.setOnlyPlayer(true);
        this.setDescription("commands.admin.setspawnpoint.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Optional<Island> optionalIsland = this.getIslands().getIslandAt(user.getLocation());
        if (!(!optionalIsland.isPresent() || !optionalIsland.get().hasNetherIsland() && World.Environment.NETHER.equals((Object)user.getLocation().getWorld().getEnvironment()) || !optionalIsland.get().hasEndIsland() && World.Environment.THE_END.equals((Object)user.getLocation().getWorld().getEnvironment()))) {
            this.askConfirmation(user, user.getTranslation("commands.admin.setspawnpoint.confirmation", new String[0]), () -> this.setSpawnPoint(user, (Island)optionalIsland.get()));
            return true;
        }
        user.sendMessage("commands.admin.setspawnpoint.no-island-here", new String[0]);
        return false;
    }

    private void setSpawnPoint(User user, Island island) {
        island.setSpawnPoint(Objects.requireNonNull(user.getLocation().getWorld()).getEnvironment(), user.getLocation());
        user.sendMessage("commands.admin.setspawnpoint.success", new String[0]);
        if (!island.isSpawn()) {
            island.getPlayersOnIsland().forEach(player -> User.getInstance(player).sendMessage("commands.admin.setspawnpoint.island-spawnpoint-changed", "[user]", user.getName()));
        }
    }
}

