/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminUnregisterCommand
extends ConfirmableCommand {
    private Island targetIsland;
    private @Nullable UUID targetUUID;

    public AdminUnregisterCommand(CompositeCommand parent) {
        super(parent, "unregister", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.unregister");
        this.setParametersHelp("commands.admin.unregister.parameters");
        this.setDescription("commands.admin.unregister.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), this.targetUUID)) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        Map<String, Island> islands = this.getIslandsXYZ(this.targetUUID);
        if (islands.isEmpty()) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (args.size() == 1) {
            if (islands.size() == 1) {
                this.targetIsland = islands.values().iterator().next();
                return true;
            }
            user.sendMessage("commands.admin.unregister.errors.player-has-more-than-one-island", new String[0]);
            user.sendMessage("commands.admin.unregister.errors.specify-island-location", new String[0]);
            return false;
        }
        if (args.size() != 2) {
            user.sendMessage("commands.admin.unregister.errors.specify-island-location", new String[0]);
            return false;
        }
        if (!islands.containsKey(args.get(1))) {
            if (args.get(1).equalsIgnoreCase("help")) {
                this.showHelp(this, user);
                return false;
            }
            user.sendMessage("commands.admin.unregister.errors.unknown-island-location", new String[0]);
            return false;
        }
        this.targetIsland = islands.get(args.get(1));
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Objects.requireNonNull(this.targetIsland);
        Objects.requireNonNull(this.targetUUID);
        this.askConfirmation(user, () -> this.unregisterIsland(user));
        return true;
    }

    void unregisterIsland(User user) {
        IslandEvent.builder().island(this.targetIsland).location(this.targetIsland.getCenter()).reason(IslandEvent.Reason.UNREGISTERED).involvedPlayer(this.targetUUID).admin(true).build();
        IslandEvent.builder().island(this.targetIsland).involvedPlayer(this.targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(1000, 0).build();
        this.targetIsland.setOwner(null);
        this.targetIsland.getMemberSet().forEach(m -> this.getIslands().removePlayer(this.targetIsland, (UUID)m));
        this.targetIsland.getMembers().clear();
        if (user.isPlayer()) {
            assert (this.targetUUID != null);
            this.targetIsland.log(new LogEntry.Builder(LogEntry.LogType.UNREGISTER).data("player", this.targetUUID.toString()).data("admin", user.getUniqueId().toString()).build());
        } else {
            assert (this.targetUUID != null);
            this.targetIsland.log(new LogEntry.Builder(LogEntry.LogType.UNREGISTER).data("player", this.targetUUID.toString()).data("admin", "console").build());
        }
        user.sendMessage("commands.admin.unregister.unregistered-island", "[xyz]", Util.xyz(this.targetIsland.getCenter().toVector()), "[name]", this.getPlayers().getName(this.targetUUID));
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        UUID uuid;
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.getLast() : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        if (args.size() == 2) {
            ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        if (args.size() > 2 && (uuid = this.getPlayers().getUUID(args.get(1))) != null) {
            return Optional.of(Util.tabLimit(new ArrayList<String>(this.getIslandsXYZ(uuid).keySet()), lastArg));
        }
        return Optional.empty();
    }

    private Map<String, Island> getIslandsXYZ(UUID target) {
        return this.getIslands().getOwnedIslands(this.getWorld(), target).stream().collect(Collectors.toMap(island -> Util.xyz(island.getCenter().toVector()), island -> island));
    }
}

