/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.Collections;
import java.util.List;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.IslandBanCommand;
import world.bentobox.bentobox.api.commands.island.IslandBanlistCommand;
import world.bentobox.bentobox.api.commands.island.IslandCreateCommand;
import world.bentobox.bentobox.api.commands.island.IslandDeletehomeCommand;
import world.bentobox.bentobox.api.commands.island.IslandExpelCommand;
import world.bentobox.bentobox.api.commands.island.IslandGoCommand;
import world.bentobox.bentobox.api.commands.island.IslandHomesCommand;
import world.bentobox.bentobox.api.commands.island.IslandInfoCommand;
import world.bentobox.bentobox.api.commands.island.IslandLanguageCommand;
import world.bentobox.bentobox.api.commands.island.IslandNearCommand;
import world.bentobox.bentobox.api.commands.island.IslandRenamehomeCommand;
import world.bentobox.bentobox.api.commands.island.IslandResetCommand;
import world.bentobox.bentobox.api.commands.island.IslandResetnameCommand;
import world.bentobox.bentobox.api.commands.island.IslandSethomeCommand;
import world.bentobox.bentobox.api.commands.island.IslandSetnameCommand;
import world.bentobox.bentobox.api.commands.island.IslandSettingsCommand;
import world.bentobox.bentobox.api.commands.island.IslandSpawnCommand;
import world.bentobox.bentobox.api.commands.island.IslandUnbanCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.user.User;

public abstract class DefaultPlayerCommand
extends CompositeCommand {
    protected DefaultPlayerCommand(GameModeAddon addon) {
        super((Addon)addon, addon.getWorldSettings().getPlayerCommandAliases().split(" ")[0], addon.getWorldSettings().getPlayerCommandAliases().split(" "));
    }

    @Override
    public void setup() {
        this.setDescription("commands.island.help.description");
        this.setOnlyPlayer(true);
        this.setPermission("island");
        new IslandGoCommand(this);
        new IslandSpawnCommand(this);
        new IslandCreateCommand(this);
        new IslandResetCommand(this);
        new IslandInfoCommand(this);
        new IslandSettingsCommand(this);
        new IslandSetnameCommand(this);
        new IslandResetnameCommand(this);
        new IslandLanguageCommand(this);
        new IslandBanCommand(this);
        new IslandUnbanCommand(this);
        new IslandBanlistCommand(this);
        new IslandExpelCommand(this);
        new IslandNearCommand(this);
        new IslandTeamCommand(this);
        new IslandSethomeCommand(this);
        new IslandDeletehomeCommand(this);
        new IslandRenamehomeCommand(this);
        new IslandHomesCommand(this);
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (user == null) {
            return false;
        }
        if (!args.isEmpty()) {
            user.sendMessage("general.errors.unknown-command", "[label]", this.getTopLabel());
            return false;
        }
        if (this.getIslands().getIsland(this.getWorld(), user.getUniqueId()) != null) {
            return this.runCommand(user, label, ((GameModeAddon)this.getAddon()).getWorldSettings().getDefaultPlayerAction(), "go");
        }
        return this.runCommand(user, label, ((GameModeAddon)this.getAddon()).getWorldSettings().getDefaultNewPlayerAction(), "create");
    }

    private boolean runCommand(User user, String label, String command, String defaultSubCommand) {
        if (command == null || command.isEmpty()) {
            command = defaultSubCommand;
        }
        if (this.getSubCommand(command).isPresent()) {
            return this.getSubCommand(command).map(c -> c.call(user, c.getLabel(), Collections.emptyList())).orElse(false);
        }
        if (command.startsWith("/")) {
            return user.performCommand(command.substring(1));
        }
        return user.performCommand(label + " " + command);
    }
}

