/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;

public class IslandSethomeCommand
extends ConfirmableCommand {
    private @Nullable Island island;

    public IslandSethomeCommand(CompositeCommand islandCommand) {
        super(islandCommand, "sethome", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.sethome");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.sethome.description");
        this.setConfigurableRankCommand();
        this.setDefaultCommandRank(500);
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        this.island = this.getIslands().getIsland(this.getWorld(), user);
        if (this.island == null || this.island.getOwner() == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        if (!this.island.onIsland(user.getLocation())) {
            user.sendMessage("commands.island.sethome.must-be-on-your-island", new String[0]);
            return false;
        }
        int rank = Objects.requireNonNull(this.island).getRank(user);
        if (rank < this.island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        int maxHomes = this.getIslands().getMaxHomes(this.island);
        if (this.getIslands().getNumberOfHomesIfAdded(this.island, String.join((CharSequence)" ", args)) > maxHomes + 1) {
            user.sendMessage("commands.island.sethome.too-many-homes", "[number]", String.valueOf(maxHomes));
            user.sendMessage("commands.island.sethome.homes-are", new String[0]);
            this.getIslands().getIslands(this.getWorld(), user).forEach(is -> is.getHomes().keySet().stream().filter(s -> !s.isEmpty()).forEach(s -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)s)));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        String number = String.join((CharSequence)" ", args);
        WorldSettings ws = this.getIWM().getWorldSettings(user.getWorld());
        if (this.getIWM().isNether(user.getWorld())) {
            if (!ws.isAllowSetHomeInNether()) {
                user.sendMessage("commands.island.sethome.nether.not-allowed", new String[0]);
                return false;
            }
            if (ws.isRequireConfirmationToSetHomeInNether()) {
                this.askConfirmation(user, user.getTranslation("commands.island.sethome.nether.confirmation", new String[0]), () -> this.doSetHome(user, number));
            } else {
                this.doSetHome(user, number);
            }
        } else if (this.getIWM().isEnd(user.getWorld())) {
            if (!ws.isAllowSetHomeInTheEnd()) {
                user.sendMessage("commands.island.sethome.the-end.not-allowed", new String[0]);
                return false;
            }
            if (ws.isRequireConfirmationToSetHomeInTheEnd()) {
                this.askConfirmation(user, user.getTranslation("commands.island.sethome.the-end.confirmation", new String[0]), () -> this.doSetHome(user, number));
            } else {
                this.doSetHome(user, number);
            }
        } else {
            this.doSetHome(user, number);
        }
        return true;
    }

    private void doSetHome(User user, String name) {
        this.getIslands().setHomeLocation(user, user.getLocation(), name);
        user.sendMessage("commands.island.sethome.home-set", new String[0]);
        if (this.island.getHomes().size() > 1) {
            user.sendMessage("commands.island.sethome.homes-are", new String[0]);
            this.island.getHomes().keySet().stream().filter(s -> !s.isEmpty()).forEach(s -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)s));
        }
    }
}

