/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamGUI;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamInviteCommand;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class IslandTeamInviteGUI {
    private final IslandTeamInviteCommand itic;
    private final IslandTeamCommand itc;
    private @Nullable PanelTemplateRecord.TemplateItem border;
    private @Nullable PanelTemplateRecord.TemplateItem background;
    private User user;
    private long page = 0L;
    private final boolean inviteCmd;
    private static final long PER_PAGE = 35L;
    private String searchName = "";
    private final BentoBox plugin;
    private final Island island;

    public IslandTeamInviteGUI(IslandTeamCommand itc, boolean invitedCmd, Island island) {
        this.island = island;
        this.plugin = itc.getPlugin();
        this.inviteCmd = invitedCmd;
        this.itic = itc.getInviteCommand();
        this.itc = itc;
        if (!new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "panels", "team_invite_panel.yml").exists()) {
            this.plugin.saveResource("panels/team_invite_panel.yml", false);
        }
    }

    void build(User user) {
        this.user = user;
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        panelBuilder.user(user);
        panelBuilder.world(user.getWorld());
        panelBuilder.template("team_invite_panel", new File(this.plugin.getDataFolder(), "panels"));
        panelBuilder.parameters("[name]", user.getName(), "[display_name]", user.getDisplayName());
        panelBuilder.registerTypeBuilder("PROSPECT", this::createProspectButton);
        panelBuilder.registerTypeBuilder("PREVIOUS", this::createPreviousButton);
        panelBuilder.registerTypeBuilder("NEXT", this::createNextButton);
        panelBuilder.registerTypeBuilder("SEARCH", this::createSearchButton);
        panelBuilder.registerTypeBuilder("BACK", this::createBackButton);
        this.border = panelBuilder.getPanelTemplate().border();
        this.background = panelBuilder.getPanelTemplate().background();
        panelBuilder.build();
    }

    private PanelItem createBackButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        this.checkTemplate(template);
        return new PanelItemBuilder().name(this.user.getTranslation(template.title(), new String[0])).icon(template.icon()).clickHandler((panel, user, clickType, clickSlot) -> {
            user.closeInventory();
            if (!this.inviteCmd) {
                new IslandTeamGUI(this.plugin, this.itc, user, this.island).build();
            }
            return true;
        }).build();
    }

    private PanelItem createSearchButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        this.checkTemplate(template);
        PanelItemBuilder pib = new PanelItemBuilder().name(this.user.getTranslation(template.title(), new String[0])).icon(template.icon()).clickHandler((panel, user, clickType, clickSlot) -> {
            user.closeInventory();
            new ConversationFactory((Plugin)BentoBox.getInstance()).withLocalEcho(false).withTimeout(90).withModality(false).withFirstPrompt((Prompt)new InviteNamePrompt()).buildConversation((Conversable)user.getPlayer()).begin();
            return true;
        });
        if (!this.searchName.isBlank()) {
            pib.description(this.user.getTranslation(Objects.requireNonNullElse(template.description(), "commands.island.team.invite.gui.button.searching"), "[name]", this.searchName));
        }
        return pib.build();
    }

    private PanelItem createNextButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        this.checkTemplate(template);
        long count = this.itc.getWorld().getPlayers().stream().filter(player -> this.user.getPlayer().canSee(player)).filter(player -> !player.equals((Object)this.user.getPlayer())).count();
        if (count > this.page * 35L) {
            return new PanelItemBuilder().name(this.user.getTranslation(template.title(), new String[0])).icon(template.icon()).clickHandler((panel, user, clickType, clickSlot) -> {
                user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                ++this.page;
                this.build(user);
                return true;
            }).build();
        }
        return this.getBlankBorder();
    }

    private void checkTemplate(ItemTemplateRecord template) {
        if (template.icon() == null) {
            this.plugin.logError("Icon in template is missing or unknown! " + String.valueOf(template));
        }
        if (template.title() == null) {
            this.plugin.logError("Title in template is missing! " + String.valueOf(template));
        }
    }

    private PanelItem createPreviousButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        this.checkTemplate(template);
        if (this.page > 0L) {
            return new PanelItemBuilder().name(this.user.getTranslation(template.title(), new String[0])).icon(template.icon()).clickHandler((panel, user, clickType, clickSlot) -> {
                user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                --this.page;
                this.build(user);
                return true;
            }).build();
        }
        return this.getBlankBorder();
    }

    private PanelItem getBlankBorder() {
        return new PanelItemBuilder().icon(Objects.requireNonNullElse(this.border.icon(), new ItemStack(Material.BARRIER))).name(Objects.requireNonNullElse(this.border.title(), "")).build();
    }

    private PanelItem createProspectButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        Island is = this.plugin.getIslands().getPrimaryIsland(this.itc.getWorld(), this.user.getUniqueId());
        if (is == null) {
            return this.getBlankBackground();
        }
        if (this.page < 0L) {
            this.page = 0L;
        }
        Stream<Player> visiblePlayers = this.itc.getWorld().getPlayers().stream().filter(arg_0 -> ((Player)this.user.getPlayer()).canSee(arg_0));
        Stream<Player> filteredPlayers = visiblePlayers.filter(player -> this.searchName.isBlank() || player.getName().toLowerCase().contains(this.searchName.toLowerCase())).filter(player -> !player.equals((Object)this.user.getPlayer()));
        Optional<Player> playerOptional = filteredPlayers.skip((long)slot.slot() + this.page * 35L).findFirst();
        return playerOptional.map(player -> this.getProspect((Player)player, template)).orElse(this.getBlankBackground());
    }

    private PanelItem getProspect(Player player, ItemTemplateRecord template) {
        if (this.itc.isInvited(player.getUniqueId()) && this.user.getUniqueId().equals(this.itc.getInvite(player.getUniqueId()).getInviter())) {
            return new PanelItemBuilder().icon(player.getName()).name(player.getDisplayName()).description(this.user.getTranslation("commands.island.team.invite.gui.button.already-invited", new String[0])).build();
        }
        List<String> desc = template.actions().stream().map(ar -> this.user.getTranslation("commands.island.team.invite.gui.tips." + ar.clickType().name() + ".name", new String[0]) + " " + this.user.getTranslation(ar.tooltip(), new String[0])).toList();
        return new PanelItemBuilder().icon(player.getName()).name(player.getDisplayName()).description(desc).clickHandler((panel, user, clickType, clickSlot) -> this.clickHandler(user, clickType, player, template.actions())).build();
    }

    private boolean clickHandler(User user, ClickType clickType, Player player, @NonNull List<ItemTemplateRecord.ActionRecords> list) {
        if (list.stream().noneMatch(ar -> clickType.equals((Object)ar.clickType()))) {
            return true;
        }
        if (clickType.equals((Object)ClickType.LEFT)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, user::closeInventory);
            if (this.itic.canExecute(user, this.itic.getLabel(), List.of(player.getName()))) {
                this.plugin.log("Invite sent to: " + player.getName() + " by " + user.getName() + " to join island in " + this.itc.getWorld().getName());
                this.itic.execute(user, this.itic.getLabel(), List.of(player.getName()));
            } else {
                this.plugin.log("Invite failed: " + player.getName() + " by " + user.getName() + " to join island in " + this.itc.getWorld().getName());
            }
        } else if (clickType.equals((Object)ClickType.RIGHT)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, user::closeInventory);
            if (this.itc.getCoopCommand().canExecute(user, this.itic.getLabel(), List.of(player.getName()))) {
                this.plugin.log("Coop: " + player.getName() + " cooped " + user.getName() + " to island in " + this.itc.getWorld().getName());
                this.itc.getCoopCommand().execute(user, this.itic.getLabel(), List.of(player.getName()));
            } else {
                this.plugin.log("Coop failed: " + player.getName() + "'s coop to " + user.getName() + " failed for island in " + this.itc.getWorld().getName());
            }
        } else if (clickType.equals((Object)ClickType.SHIFT_LEFT)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, user::closeInventory);
            if (this.itc.getTrustCommand().canExecute(user, this.itic.getLabel(), List.of(player.getName()))) {
                this.plugin.log("Trust: " + player.getName() + " trusted " + user.getName() + " to island in " + this.itc.getWorld().getName());
                this.itc.getTrustCommand().execute(user, this.itic.getLabel(), List.of(player.getName()));
            } else {
                this.plugin.log("Trust failed: " + player.getName() + "'s trust failed for " + user.getName() + " for island in " + this.itc.getWorld().getName());
            }
        }
        return true;
    }

    private PanelItem getBlankBackground() {
        return new PanelItemBuilder().icon(Objects.requireNonNullElse(this.background.icon(), new ItemStack(Material.BARRIER))).name(Objects.requireNonNullElse(this.background.title(), "")).build();
    }

    class InviteNamePrompt
    extends StringPrompt {
        InviteNamePrompt() {
        }

        public @NonNull String getPromptText(@NonNull ConversationContext context) {
            return IslandTeamInviteGUI.this.user.getTranslation("commands.island.team.invite.gui.enter-name", new String[0]);
        }

        public Prompt acceptInput(@NonNull ConversationContext context, String input) {
            if (IslandTeamInviteGUI.this.itic.canExecute(IslandTeamInviteGUI.this.user, IslandTeamInviteGUI.this.itic.getLabel(), List.of(input)) && IslandTeamInviteGUI.this.itic.execute(IslandTeamInviteGUI.this.user, IslandTeamInviteGUI.this.itic.getLabel(), List.of(input))) {
                return Prompt.END_OF_CONVERSATION;
            }
            IslandTeamInviteGUI.this.searchName = input;
            Bukkit.getScheduler().runTaskLater((Plugin)BentoBox.getInstance(), () -> IslandTeamInviteGUI.this.build(IslandTeamInviteGUI.this.user), 20L);
            return Prompt.END_OF_CONVERSATION;
        }
    }
}

