/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandTeamUntrustCommand
extends CompositeCommand {
    public IslandTeamUntrustCommand(CompositeCommand parentCommand) {
        super(parentCommand, "untrust", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.team.trust");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.team.untrust.parameters");
        this.setDescription("commands.island.team.untrust.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && !this.getIslands().hasIsland(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.getFirst());
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        return this.unTrustCmd(user, targetUUID);
    }

    protected boolean unTrustCmd(User user, UUID targetUUID) {
        if (user.getUniqueId().equals(targetUUID)) {
            user.sendMessage("commands.island.team.untrust.cannot-untrust-yourself", new String[0]);
            return false;
        }
        if (this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId()).inTeam(targetUUID)) {
            user.sendMessage("commands.island.team.untrust.cannot-untrust-member", new String[0]);
            return false;
        }
        User target = User.getInstance(targetUUID);
        int rank = this.getIslands().getIsland(this.getWorld(), user).getRank(target);
        if (rank != 400) {
            user.sendMessage("commands.island.team.untrust.player-not-trusted", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (island != null) {
            this.getIslands().removePlayer(island, targetUUID);
            user.sendMessage("commands.island.team.untrust.success", "[name]", target.getName(), "[display_name]", target.getDisplayName());
            target.sendMessage("commands.island.team.untrust.you-are-no-longer-trusted", "[name]", user.getName(), "[display_name]", user.getDisplayName());
            if (this.getSettings().getTrustCooldown() > 0 && this.getParent() != null) {
                this.getParent().getSubCommand("trust").ifPresent(subCommand -> subCommand.setCooldown(island.getUniqueId(), targetUUID.toString(), this.getSettings().getTrustCooldown() * 60));
            }
            IslandEvent.builder().island(island).involvedPlayer(targetUUID).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(400, 0).build();
            return true;
        }
        user.sendMessage("general.errors.general", new String[0]);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (island != null) {
            List<String> options = island.getMembers().entrySet().stream().filter(e -> (Integer)e.getValue() == 400).map(e -> Bukkit.getOfflinePlayer((UUID)((UUID)e.getKey()))).map(OfflinePlayer::getName).toList();
            String lastArg = !args.isEmpty() ? args.getLast() : "";
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        return Optional.empty();
    }
}

