/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.flags.clicklisteners;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.flags.FlagProtectionChangeEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TabbedPanel;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.panels.settings.SettingsTab;
import world.bentobox.bentobox.util.Util;

public class CycleClick
implements PanelItem.ClickHandler {
    protected final BentoBox plugin = BentoBox.getInstance();
    protected Island island;
    protected User user;
    protected boolean changeOccurred;
    private final String id;
    private int minRank = 0;
    private int maxRank = 1000;

    public CycleClick(String id) {
        this.id = id;
    }

    public CycleClick(String id, int minRank, int maxRank) {
        this.id = id;
        this.minRank = minRank;
        this.maxRank = maxRank;
    }

    @Override
    public boolean onClick(Panel panel, User user2, ClickType click, int slot) {
        if (panel.getWorld().isEmpty()) {
            this.plugin.logError("Panel " + panel.getName() + " has no world associated with it. Please report this bug to the author.");
            return true;
        }
        TabbedPanel tp = (TabbedPanel)panel;
        SettingsTab st = (SettingsTab)tp.getActiveTab();
        this.island = st.getIsland();
        this.user = user2;
        this.changeOccurred = false;
        String prefix = this.plugin.getIWM().getPermissionPrefix(Util.getWorld(panel.getWorld().get()));
        String reqPerm = prefix + "settings." + this.id;
        String allPerms = prefix + "settings.*";
        if (!(this.user.hasPermission(reqPerm) || this.user.hasPermission(allPerms) || this.user.isOp() || this.user.hasPermission(prefix + "admin.settings"))) {
            this.user.sendMessage("general.errors.no-permission", "[permission]", reqPerm);
            this.user.getPlayer().playSound(this.user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        if (this.island != null && (this.user.isOp() || this.island.isAllowed(this.user, Flags.CHANGE_SETTINGS) || this.user.hasPermission(prefix + "admin.settings"))) {
            this.changeOccurred = true;
            this.plugin.getFlagsManager().getFlag(this.id).ifPresent(flag -> {
                int currentRank = this.island.getFlag((Flag)flag);
                if (click.equals((Object)ClickType.LEFT)) {
                    this.leftClick((Flag)flag, currentRank);
                } else if (click.equals((Object)ClickType.RIGHT)) {
                    this.rightClick((Flag)flag, currentRank);
                } else if (click.equals((Object)ClickType.SHIFT_LEFT) && user2.isOp()) {
                    this.leftShiftClick((Flag)flag, panel.getWorld().get());
                }
            });
        } else {
            this.reportError();
        }
        return true;
    }

    private void reportError() {
        if (this.island == null) {
            this.user.sendMessage("general.errors.not-on-island", new String[0]);
        } else {
            this.user.sendMessage("general.errors.insufficient-rank", "[rank]", this.user.getTranslation(RanksManager.getInstance().getRank(Objects.requireNonNull(this.island).getRank(this.user)), new String[0]));
        }
        this.user.getPlayer().playSound(this.user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
    }

    private void leftClick(Flag flag, int currentRank) {
        if (currentRank >= this.maxRank) {
            this.island.setFlag(flag, this.minRank);
        } else {
            this.island.setFlag(flag, RanksManager.getInstance().getRankUpValue(currentRank));
        }
        this.user.getPlayer().playSound(this.user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
        Bukkit.getPluginManager().callEvent((Event)new FlagProtectionChangeEvent(this.island, this.user.getUniqueId(), flag, this.island.getFlag(flag)));
        if (flag.hasSubflags()) {
            flag.getSubflags().forEach(subflag -> Bukkit.getPluginManager().callEvent((Event)new FlagProtectionChangeEvent(this.island, this.user.getUniqueId(), (Flag)subflag, this.island.getFlag((Flag)subflag))));
        }
    }

    private void rightClick(Flag flag, int currentRank) {
        if (currentRank <= this.minRank) {
            this.island.setFlag(flag, this.maxRank);
        } else {
            this.island.setFlag(flag, RanksManager.getInstance().getRankDownValue(currentRank));
        }
        this.user.getPlayer().playSound(this.user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        Bukkit.getPluginManager().callEvent((Event)new FlagProtectionChangeEvent(this.island, this.user.getUniqueId(), flag, this.island.getFlag(flag)));
        if (flag.hasSubflags()) {
            flag.getSubflags().forEach(subflag -> Bukkit.getPluginManager().callEvent((Event)new FlagProtectionChangeEvent(this.island, this.user.getUniqueId(), (Flag)subflag, this.island.getFlag((Flag)subflag))));
        }
    }

    private void leftShiftClick(Flag flag, World world) {
        if (!this.plugin.getIWM().getHiddenFlags(world).contains(flag.getID())) {
            this.plugin.getIWM().getHiddenFlags(world).add(flag.getID());
            this.user.getPlayer().playSound(this.user.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
        } else {
            this.plugin.getIWM().getHiddenFlags(world).remove(flag.getID());
            this.user.getPlayer().playSound(this.user.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
        }
        this.plugin.getIWM().getAddon(world).ifPresent(GameModeAddon::saveWorldSettings);
    }

    public void setMinRank(int minRank) {
        this.minRank = minRank;
    }

    public void setMaxRank(int maxRank) {
        this.maxRank = maxRank;
    }
}

