/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.api.user.User;

public class TemplatedPanel
extends Panel {
    private final PanelTemplateRecord panelTemplate;
    private final User user;
    private final Map<String, BiFunction<ItemTemplateRecord, ItemSlot, PanelItem>> typeCreators;
    private final Map<String, ItemSlot> typeIndex;
    private final Map<String, Integer> typeSlotMap;
    private final String[] parameters;

    public TemplatedPanel(@NonNull TemplatedPanelBuilder builder) {
        this.user = builder.getUser();
        this.setWorld(builder.getWorld());
        this.setListener(builder.getListener());
        this.panelTemplate = builder.getPanelTemplate();
        this.typeCreators = new HashMap<String, BiFunction<ItemTemplateRecord, ItemSlot, PanelItem>>(builder.getObjectCreatorMap());
        this.typeIndex = new HashMap<String, ItemSlot>(builder.getObjectCreatorMap().size());
        this.typeSlotMap = new HashMap<String, Integer>(builder.getObjectCreatorMap().size());
        this.parameters = builder.getParameters().toArray(new String[0]);
        if (this.panelTemplate == null) {
            BentoBox.getInstance().logError("Cannot generate panel because template is not loaded.");
        } else {
            this.generatePanel();
        }
    }

    private void generatePanel() {
        Map<Integer, PanelItem> items = switch (this.panelTemplate.type()) {
            default -> throw new MatchException(null, null);
            case Panel.Type.INVENTORY -> this.populateInventoryPanel(new PanelItem[6][9]);
            case Panel.Type.HOPPER -> this.populateInventoryPanel(new PanelItem[1][5]);
            case Panel.Type.DROPPER -> this.populateInventoryPanel(new PanelItem[3][3]);
            case Panel.Type.ANVIL -> this.populateInventoryPanel(new PanelItem[4][9]);
        };
        super.makePanel(this.user.getTranslation(this.panelTemplate.title(), this.parameters), items, items.keySet().stream().max(Comparator.naturalOrder()).orElse(9), this.user, this.getListener().orElse(null), this.panelTemplate.type());
    }

    private @NonNull Map<Integer, PanelItem> populateInventoryPanel(PanelItem[][] itemArray) {
        this.preProcessPanelTemplate(itemArray);
        this.processItemData(itemArray);
        this.removeEmptyLines(itemArray);
        this.fillBorder(itemArray);
        this.fillBackground(itemArray);
        return this.createItemMap(itemArray);
    }

    private void preProcessPanelTemplate(PanelItem[][] itemArray) {
        int numRows = itemArray.length;
        int numCols = itemArray[0].length;
        for (int i = 0; i < numRows; ++i) {
            for (int k = 0; k < numCols; ++k) {
                ItemTemplateRecord rec = this.panelTemplate.content()[i][k];
                if (rec == null || !rec.dataMap().containsKey("type")) continue;
                String type = String.valueOf(rec.dataMap().get("type"));
                int counter = this.typeSlotMap.computeIfAbsent(type, key -> 0);
                this.typeSlotMap.put(type, counter + 1);
            }
        }
    }

    private void processItemData(PanelItem[][] itemArray) {
        int numRows = itemArray.length;
        int numCols = itemArray[0].length;
        for (int i = 0; i < numRows; ++i) {
            for (int k = 0; k < numCols; ++k) {
                itemArray[i][k] = this.makeButton(this.panelTemplate.content()[i][k]);
            }
        }
    }

    private void removeEmptyLines(PanelItem[][] itemArray) {
        boolean[] showLine = this.panelTemplate.forcedRows();
        int numRows = itemArray.length;
        int numCols = itemArray[0].length;
        for (int i = 0; i < numRows; ++i) {
            boolean emptyLine = true;
            for (int k = 0; emptyLine && k < numCols; ++k) {
                emptyLine = itemArray[i][k] == null;
            }
            showLine[i] = showLine[i] || !emptyLine;
        }
    }

    private void fillBorder(PanelItem[][] itemArray) {
        if (this.panelTemplate.border() == null) {
            return;
        }
        PanelItem template = this.makeTemplate(this.panelTemplate.border());
        int numRows = itemArray.length;
        int numCols = itemArray[0].length;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                if (row != 0 && row != numRows - 1 && col != 0 && col != numCols - 1 || itemArray[row][col] != null) continue;
                itemArray[row][col] = template;
            }
        }
        this.panelTemplate.forcedRows()[0] = true;
        this.panelTemplate.forcedRows()[numRows - 1] = true;
    }

    private void fillBackground(PanelItem[][] itemArray) {
        if (this.panelTemplate.background() == null) {
            return;
        }
        PanelItem template = this.makeTemplate(this.panelTemplate.background());
        int numRows = itemArray.length;
        int numCols = itemArray[0].length;
        for (int i = 0; i < numRows; ++i) {
            for (int k = 0; k < numCols; ++k) {
                if (itemArray[i][k] != null) continue;
                itemArray[i][k] = template;
            }
        }
    }

    private Map<Integer, PanelItem> createItemMap(PanelItem[][] itemArray) {
        HashMap<Integer, PanelItem> itemMap = new HashMap<Integer, PanelItem>(itemArray.length * itemArray[0].length);
        int correctIndex = 0;
        for (int i = 0; i < itemArray.length; ++i) {
            boolean iterate = this.panelTemplate.forcedRows()[i];
            for (int k = 0; iterate && k < itemArray[i].length; ++k) {
                if (itemArray[i][k] != null) {
                    itemMap.put(correctIndex, itemArray[i][k]);
                }
                ++correctIndex;
            }
        }
        return itemMap;
    }

    private @Nullable PanelItem makeButton(@Nullable ItemTemplateRecord rec) {
        if (rec == null) {
            return null;
        }
        if (rec.dataMap().containsKey("type")) {
            return this.makeAddonButton(rec);
        }
        PanelItemBuilder itemBuilder = new PanelItemBuilder();
        if (rec.icon() != null) {
            itemBuilder.icon(rec.icon().clone());
        }
        if (rec.title() != null) {
            itemBuilder.name(this.user.getTranslation(rec.title(), new String[0]));
        }
        if (rec.description() != null) {
            itemBuilder.description(this.user.getTranslation(rec.description(), new String[0]));
        }
        return itemBuilder.build();
    }

    private @Nullable PanelItem makeAddonButton(@NonNull ItemTemplateRecord rec) {
        String type = String.valueOf(rec.dataMap().getOrDefault("type", ""));
        if (!this.typeCreators.containsKey(type)) {
            return this.makeFallBack(rec.fallback());
        }
        BiFunction<ItemTemplateRecord, ItemSlot, PanelItem> buttonBuilder = this.typeCreators.get(type);
        ItemSlot itemSlot = this.typeIndex.containsKey(type) ? this.typeIndex.get(type) : new ItemSlot(0, this);
        this.typeIndex.put(type, itemSlot.nextItemSlot());
        PanelItem item = buttonBuilder.apply(rec, itemSlot);
        return item == null ? this.makeFallBack(rec.fallback()) : item;
    }

    private @Nullable PanelItem makeFallBack(@Nullable ItemTemplateRecord rec) {
        return rec == null ? null : this.makeButton(rec.fallback());
    }

    private PanelItem makeTemplate(PanelTemplateRecord.TemplateItem rec) {
        PanelItemBuilder itemBuilder = new PanelItemBuilder();
        if (rec.icon() != null) {
            itemBuilder.icon(rec.icon().clone());
        }
        if (rec.title() != null) {
            itemBuilder.name(this.user.getTranslation(rec.title(), new String[0]));
        }
        if (rec.description() != null) {
            itemBuilder.description(this.user.getTranslation(rec.description(), new String[0]));
        }
        return itemBuilder.build();
    }

    public record ItemSlot(int slot, TemplatedPanel parentPanel) {
        ItemSlot nextItemSlot() {
            return new ItemSlot(this.slot() + 1, this.parentPanel());
        }

        public Map<String, Integer> amountMap() {
            return this.parentPanel.typeSlotMap;
        }

        public int amount(String type) {
            return this.amount(type, 0);
        }

        public int amount(String type, int defaultValue) {
            return this.parentPanel.typeSlotMap.getOrDefault(type, defaultValue);
        }
    }
}

