/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.blueprints.dataobjects;

import com.google.gson.annotations.Expose;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;

public class BlueprintEntity {
    @Expose
    private Boolean adult;
    @Expose
    public BlueprintBlock blockDisp;
    @Expose
    private Boolean chest;
    @Expose
    private DyeColor color;
    @Expose
    private String customName;
    @Expose
    public DisplayRec displayRec;
    @Expose
    private Integer domestication;
    @Expose
    private Integer experience;
    @Expose
    private Map<Integer, ItemStack> inventory;
    @Expose
    public ItemDispRec itemDisp;
    @Expose
    private Integer level;
    @Expose
    Double MMLevel;
    @Expose
    Float MMpower;
    @Expose
    String MMStance;
    @Expose
    String MMtype;
    @Expose
    private String npc;
    @Expose
    private Villager.Profession profession;
    @Expose
    private Horse.Style style;
    @Expose
    private Boolean tamed;
    @Expose
    public TextDisplayRec textDisp;
    @Expose
    private EntityType type;
    @Expose
    private Villager.Type villagerType;
    @Expose
    private double x;
    @Expose
    private double y;
    @Expose
    private double z;
    @Expose
    private Boolean glowing;
    @Expose
    private Boolean gravity;
    @Expose
    private Boolean visualFire;
    @Expose
    private Boolean silent;
    @Expose
    private Boolean invulnerable;
    @Expose
    private int fireTicks;
    @Expose
    private ItemFrameRec itemFrame;

    public BlueprintEntity(Entity entity) {
        AbstractHorse horse;
        Ageable ageable;
        Colorable c;
        this.setType(entity.getType());
        this.setCustomName(entity.getCustomName());
        this.setGlowing(entity.isGlowing());
        this.setGravity(entity.hasGravity());
        this.setVisualFire(entity.isVisualFire());
        this.setSilent(entity.isSilent());
        this.setInvulnerable(entity.isInvulnerable());
        this.setFireTicks(entity.getFireTicks());
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.configVillager(villager);
        }
        if (entity instanceof Colorable && (c = (Colorable)entity).getColor() != null) {
            this.setColor(c.getColor());
        }
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            this.setTamed(tameable.isTamed());
        }
        if (entity instanceof ChestedHorse) {
            ChestedHorse chestedHorse = (ChestedHorse)entity;
            this.setChest(chestedHorse.isCarryingChest());
        }
        if (entity instanceof Ageable && !(ageable = (Ageable)entity).isAdult()) {
            this.setAdult(false);
        }
        if (entity instanceof AbstractHorse) {
            horse = (AbstractHorse)entity;
            this.setDomestication(horse.getDomestication());
            this.setInventory(new HashMap<Integer, ItemStack>());
            for (int i = 0; i < horse.getInventory().getSize(); ++i) {
                ItemStack item = horse.getInventory().getItem(i);
                if (item == null) continue;
                this.getInventory().put(i, item);
            }
        }
        if (entity instanceof Horse) {
            horse = (Horse)entity;
            this.setStyle(horse.getStyle());
        }
        if (entity instanceof Display) {
            Display disp = (Display)entity;
            this.storeDisplay(disp);
        }
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            this.setItemFrame(new ItemFrameRec(frame.getItem(), frame.getRotation(), frame.isFixed(), frame.isVisible(), frame.getItemDropChance()));
        }
    }

    public BlueprintEntity() {
    }

    private void configVillager(Villager v) {
        this.setExperience(v.getVillagerExperience());
        this.setLevel(v.getVillagerLevel());
        this.setProfession(v.getProfession());
        this.setVillagerType(v.getVillagerType());
    }

    public void configureEntity(Entity e) {
        AbstractHorse horse;
        e.setGlowing(this.isGlowing());
        e.setGravity(this.isGravity());
        e.setVisualFire(this.isVisualFire());
        e.setSilent(this.isSilent());
        e.setInvulnerable(this.isInvulnerable());
        e.setFireTicks(this.getFireTicks());
        if (e instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)e;
            this.setFrame(frame);
        }
        if (e instanceof Villager) {
            Villager villager = (Villager)e;
            this.setVillager(villager);
        }
        if (e instanceof Colorable) {
            Colorable c = (Colorable)e;
            c.setColor(this.color);
        }
        if (this.tamed != null && e instanceof Tameable) {
            Tameable tameable = (Tameable)e;
            tameable.setTamed(this.tamed.booleanValue());
        }
        if (this.chest != null && e instanceof ChestedHorse) {
            ChestedHorse chestedHorse = (ChestedHorse)e;
            chestedHorse.setCarryingChest(this.chest.booleanValue());
        }
        if (this.adult != null && e instanceof Ageable) {
            Ageable ageable = (Ageable)e;
            if (this.adult.booleanValue()) {
                ageable.setAdult();
            } else {
                ageable.setBaby();
            }
        }
        if (e instanceof AbstractHorse) {
            horse = (AbstractHorse)e;
            if (this.domestication != null) {
                horse.setDomestication(this.domestication.intValue());
            }
            if (this.inventory != null) {
                this.inventory.forEach((index, item) -> horse.getInventory().setItem(index.intValue(), item));
            }
        }
        if (this.style != null && e instanceof Horse) {
            horse = (Horse)e;
            horse.setStyle(this.style);
        }
        e.getLocation().add(new Vector(this.x - 0.5, this.y, this.z - 0.5));
    }

    private void setFrame(ItemFrame frame) {
        if (this.itemFrame == null) {
            return;
        }
        frame.setItem(this.itemFrame.item());
        frame.setVisible(this.itemFrame.isVisible);
        frame.setFixed(frame.isFixed());
        frame.setRotation(this.itemFrame.rotation());
        frame.setItemDropChance(this.itemFrame.dropChance());
    }

    public Boolean getAdult() {
        return this.adult;
    }

    public Boolean getChest() {
        return this.chest;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Integer getDomestication() {
        return this.domestication;
    }

    public Integer getExperience() {
        return this.experience;
    }

    public Map<Integer, ItemStack> getInventory() {
        return this.inventory;
    }

    public Integer getLevel() {
        return this.level;
    }

    public MythicMobRecord getMythicMobsRecord() {
        if (this.MMtype == null || this.MMLevel == null || this.MMpower == null || this.MMStance == null) {
            return null;
        }
        return new MythicMobRecord(this.MMtype, this.getCustomName(), this.MMLevel, this.MMpower.floatValue(), this.MMStance);
    }

    public String getNpc() {
        return this.npc;
    }

    public Villager.Profession getProfession() {
        return this.profession;
    }

    public Horse.Style getStyle() {
        return this.style;
    }

    public Boolean getTamed() {
        return this.tamed;
    }

    public EntityType getType() {
        return this.type;
    }

    public Villager.Type getVillagerType() {
        return this.villagerType;
    }

    public void setAdult(Boolean adult) {
        this.adult = adult;
    }

    public void setChest(Boolean chest) {
        this.chest = chest;
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void setDisplay(Location pos) {
        World world = pos.getWorld();
        Location newPos = pos.clone().add(new Vector(this.x - 0.5, this.y, this.z - 0.5));
        Display d = null;
        if (this.blockDisp != null) {
            d = (Display)world.spawn(newPos, BlockDisplay.class);
            BlockData bd = Bukkit.createBlockData((String)this.blockDisp.getBlockData());
            ((BlockDisplay)d).setBlock(bd);
        } else if (this.itemDisp != null) {
            d = (Display)world.spawn(newPos, ItemDisplay.class);
            ((ItemDisplay)d).setItemStack(this.itemDisp.item());
            ((ItemDisplay)d).setItemDisplayTransform(this.itemDisp.itemDispTrans());
        } else if (this.textDisp != null) {
            d = (Display)world.spawn(newPos, TextDisplay.class);
            ((TextDisplay)d).setText(this.textDisp.text());
            ((TextDisplay)d).setAlignment(this.textDisp.alignment());
            ((TextDisplay)d).setBackgroundColor(this.textDisp.bgColor());
            ((TextDisplay)d).setLineWidth(this.textDisp.lWidth());
            ((TextDisplay)d).setTextOpacity(this.textDisp.opacity());
            ((TextDisplay)d).setShadowed(this.textDisp.isShadowed());
            ((TextDisplay)d).setSeeThrough(this.textDisp.isSeeThrough());
            ((TextDisplay)d).setBackgroundColor(this.textDisp.bgColor());
        }
        if (d != null && this.displayRec != null) {
            d.setCustomName(this.getCustomName());
            d.setBillboard(this.displayRec.billboard());
            d.setBrightness(this.displayRec.brightness());
            d.setDisplayHeight(this.displayRec.height());
            d.setDisplayWidth(this.displayRec.width());
            d.setGlowColorOverride(this.displayRec.glowColorOverride());
            d.setInterpolationDelay(this.displayRec.interpolationDelay());
            d.setInterpolationDuration(this.displayRec.interpolationDuration());
            d.setShadowRadius(this.displayRec.shadowRadius());
            d.setShadowStrength(this.displayRec.shadowStrength());
            d.setTeleportDuration(this.displayRec.teleportDuration());
            d.setTransformation(this.displayRec.transformation());
            d.setViewRange(this.displayRec.range());
            ArmorStand armorStand = (ArmorStand)world.spawnEntity(newPos, EntityType.ARMOR_STAND);
            armorStand.setSmall(true);
            armorStand.setGravity(false);
            armorStand.setInvisible(true);
            NamespacedKey key = new NamespacedKey((Plugin)BentoBox.getInstance(), "associatedDisplayEntity");
            armorStand.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)d.getUniqueId().toString());
        }
    }

    public void setDomestication(int domestication) {
        this.domestication = domestication;
    }

    public void setDomestication(Integer domestication) {
        this.domestication = domestication;
    }

    public void setExperience(Integer experience) {
        this.experience = experience;
    }

    public void setInventory(Map<Integer, ItemStack> inventory) {
        this.inventory = inventory;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setMythicMobsRecord(MythicMobRecord mmr) {
        this.setCustomName(mmr.displayName());
        this.MMtype = mmr.type();
        this.MMLevel = mmr.level();
        this.MMStance = mmr.stance();
        this.MMpower = Float.valueOf(mmr.power());
    }

    public void setNpc(String npc) {
        this.npc = npc;
    }

    public void setProfession(Villager.Profession profession) {
        this.profession = profession;
    }

    public void setStyle(Horse.Style style) {
        this.style = style;
    }

    public void setTamed(Boolean tamed) {
        this.tamed = tamed;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    private void setVillager(Villager v) {
        v.setProfession(this.profession == null ? Villager.Profession.NONE : this.profession);
        v.setVillagerExperience(this.experience == null ? 0 : this.experience);
        v.setVillagerLevel(this.level == null ? 0 : this.level);
        v.setVillagerType(this.villagerType == null ? Villager.Type.PLAINS : this.villagerType);
    }

    public void setVillagerType(Villager.Type villagerType) {
        this.villagerType = villagerType;
    }

    public void storeDisplay(Display disp) {
        this.displayRec = new DisplayRec(disp.getBillboard(), disp.getBrightness(), disp.getDisplayHeight(), disp.getDisplayWidth(), disp.getGlowColorOverride(), disp.getInterpolationDelay(), disp.getInterpolationDuration(), disp.getShadowRadius(), disp.getShadowStrength(), disp.getTeleportDuration(), disp.getTransformation(), disp.getViewRange());
        Display display = disp;
        Objects.requireNonNull(display);
        Display display2 = display;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockDisplay.class, ItemDisplay.class, TextDisplay.class}, (Object)display2, n)) {
            case 0: {
                BlockDisplay bd = (BlockDisplay)display2;
                this.blockDisp = new BlueprintBlock(bd.getBlock().getAsString());
                break;
            }
            case 1: {
                ItemDisplay id = (ItemDisplay)display2;
                this.itemDisp = new ItemDispRec(id.getItemStack(), id.getItemDisplayTransform());
                break;
            }
            case 2: {
                TextDisplay td = (TextDisplay)display2;
                this.textDisp = new TextDisplayRec(td.getText(), td.getAlignment(), td.getBackgroundColor(), td.getFacing(), td.getLineWidth(), td.getTextOpacity(), td.isShadowed(), td.isSeeThrough(), td.isDefaultBackground());
                break;
            }
        }
        this.x = disp.getLocation().getX() - (double)disp.getLocation().getBlockX();
        this.y = disp.getLocation().getY() - (double)disp.getLocation().getBlockY();
        this.z = disp.getLocation().getZ() - (double)disp.getLocation().getBlockZ();
    }

    public boolean isGlowing() {
        if (this.glowing == null) {
            this.glowing = false;
        }
        return this.glowing;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public boolean isGravity() {
        if (this.gravity == null) {
            this.gravity = true;
        }
        return this.gravity;
    }

    public void setGravity(boolean gravity) {
        this.gravity = gravity;
    }

    public boolean isVisualFire() {
        if (this.visualFire == null) {
            this.visualFire = false;
        }
        return this.visualFire;
    }

    public void setVisualFire(boolean visualFire) {
        this.visualFire = visualFire;
    }

    public boolean isSilent() {
        if (this.silent == null) {
            this.silent = false;
        }
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isInvulnerable() {
        if (this.invulnerable == null) {
            this.invulnerable = false;
        }
        return this.invulnerable;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public void setFireTicks(int fireTicks) {
        this.fireTicks = fireTicks;
    }

    public ItemFrameRec getItemFrame() {
        return this.itemFrame;
    }

    public void setItemFrame(ItemFrameRec itemFrame) {
        this.itemFrame = itemFrame;
    }

    public record ItemFrameRec(@Expose ItemStack item, @Expose Rotation rotation, @Expose boolean isFixed, @Expose boolean isVisible, @Expose float dropChance) {
    }

    public record MythicMobRecord(String type, String displayName, double level, float power, String stance) {
    }

    public record ItemDispRec(@Expose ItemStack item, @Expose ItemDisplay.ItemDisplayTransform itemDispTrans) {
    }

    public record TextDisplayRec(@Expose String text, @Expose TextDisplay.TextAlignment alignment, @Expose Color bgColor, @Expose BlockFace face, @Expose int lWidth, @Expose byte opacity, @Expose boolean isShadowed, @Expose boolean isSeeThrough, @Expose boolean isDefaultBg) {
    }

    public record DisplayRec(@Expose Display.Billboard billboard, @Expose Display.Brightness brightness, @Expose float height, @Expose float width, @Expose Color glowColorOverride, @Expose int interpolationDelay, @Expose int interpolationDuration, @Expose float shadowRadius, @Expose float shadowStrength, @Expose int teleportDuration, @Expose Transformation transformation, @Expose float range) {
    }
}

