/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.commands;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.panels.reader.TemplateReader;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.commands.reload.BentoBoxReloadLocalesCommand;
import world.bentobox.bentobox.listeners.PanelListenerManager;

public class BentoBoxReloadCommand
extends ConfirmableCommand {
    public BentoBoxReloadCommand(CompositeCommand parent) {
        super(parent, "reload", "rl");
    }

    @Override
    public void setup() {
        this.setPermission("bentobox.admin.reload");
        this.setParametersHelp("commands.bentobox.reload.parameters");
        this.setDescription("commands.bentobox.reload.description");
        new BentoBoxReloadLocalesCommand(this);
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.askConfirmation(user, user.getTranslation("commands.bentobox.reload.warning", new String[0]), () -> {
                this.getPlugin().getPlaceholdersManager().unregisterAll();
                PanelListenerManager.closeAllPanels();
                TemplateReader.clearPanels();
                this.getPlugin().loadSettings();
                user.sendMessage("commands.bentobox.reload.settings-reloaded", new String[0]);
                this.getPlugin().getLocalesManager().reloadLanguages();
                user.sendMessage("commands.bentobox.reload.locales-reloaded", new String[0]);
                this.getPlugin().getAddonsManager().getGameModeAddons().forEach(this.getPlugin().getPlaceholdersManager()::registerDefaultPlaceholders);
            });
        } else {
            this.showHelp(this, user);
        }
        return true;
    }
}

