/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database;

import java.util.Arrays;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;
import world.bentobox.bentobox.database.json.JSONDatabase;
import world.bentobox.bentobox.database.mongodb.MongoDBDatabase;
import world.bentobox.bentobox.database.sql.mariadb.MariaDBDatabase;
import world.bentobox.bentobox.database.sql.mysql.MySQLDatabase;
import world.bentobox.bentobox.database.sql.postgresql.PostgreSQLDatabase;
import world.bentobox.bentobox.database.sql.sqlite.SQLiteDatabase;
import world.bentobox.bentobox.database.transition.Json2MariaDBDatabase;
import world.bentobox.bentobox.database.transition.Json2MongoDBDatabase;
import world.bentobox.bentobox.database.transition.Json2MySQLDatabase;
import world.bentobox.bentobox.database.transition.Json2PostgreSQLDatabase;
import world.bentobox.bentobox.database.transition.Json2SQLiteDatabase;
import world.bentobox.bentobox.database.transition.MariaDB2JsonDatabase;
import world.bentobox.bentobox.database.transition.MongoDB2JsonDatabase;
import world.bentobox.bentobox.database.transition.MySQL2JsonDatabase;
import world.bentobox.bentobox.database.transition.PostgreSQL2JsonDatabase;
import world.bentobox.bentobox.database.transition.SQLite2JsonDatabase;
import world.bentobox.bentobox.database.transition.Yaml2JsonDatabase;
import world.bentobox.bentobox.database.transition.Yaml2MariaDBDatabase;
import world.bentobox.bentobox.database.transition.Yaml2MongoDBDatabase;
import world.bentobox.bentobox.database.transition.Yaml2MySQLDatabase;
import world.bentobox.bentobox.database.transition.Yaml2SQLiteDatabase;
import world.bentobox.bentobox.database.yaml.YamlDatabase;

public interface DatabaseSetup {
    public static DatabaseSetup getDatabase() {
        BentoBox plugin = BentoBox.getInstance();
        return Arrays.stream(DatabaseType.values()).filter(plugin.getSettings().getDatabaseType()::equals).findFirst().map(t -> t.database).orElseGet(() -> DatabaseType.JSON.database);
    }

    public <T> AbstractDatabaseHandler<T> getHandler(Class<T> var1);

    public static enum DatabaseType {
        YAML(new YamlDatabase()),
        YAML2JSON(new Yaml2JsonDatabase()),
        YAML2MYSQL(new Yaml2MySQLDatabase()),
        YAML2MARIADB(new Yaml2MariaDBDatabase()),
        YAML2MONGODB(new Yaml2MongoDBDatabase()),
        YAML2SQLITE(new Yaml2SQLiteDatabase()),
        JSON(new JSONDatabase()),
        JSON2MYSQL(new Json2MySQLDatabase()),
        JSON2MARIADB(new Json2MariaDBDatabase()),
        JSON2MONGODB(new Json2MongoDBDatabase()),
        JSON2SQLITE(new Json2SQLiteDatabase()),
        JSON2POSTGRESQL(new Json2PostgreSQLDatabase()),
        MYSQL(new MySQLDatabase()),
        MYSQL2JSON(new MySQL2JsonDatabase()),
        MARIADB(new MariaDBDatabase()),
        MARIADB2JSON(new MariaDB2JsonDatabase()),
        MONGODB(new MongoDBDatabase()),
        MONGODB2JSON(new MongoDB2JsonDatabase()),
        SQLITE(new SQLiteDatabase()),
        SQLITE2JSON(new SQLite2JsonDatabase()),
        POSTGRESQL(new PostgreSQLDatabase()),
        POSTGRESQL2JSON(new PostgreSQL2JsonDatabase());

        final DatabaseSetup database;

        private DatabaseType(DatabaseSetup database) {
            this.database = database;
        }
    }
}

