/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import world.bentobox.bentobox.BentoBox;

public class ItemStackTypeAdapter
extends TypeAdapter<ItemStack> {
    public void write(JsonWriter out, ItemStack value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        YamlConfiguration c = new YamlConfiguration();
        c.set("is", (Object)value);
        out.value(c.saveToString());
    }

    public ItemStack read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        YamlConfiguration c = new YamlConfiguration();
        String n = reader.nextString();
        if (n.contains("type:")) {
            String type = n.substring(n.indexOf("type:") + 6);
            Material m = Material.matchMaterial((String)(type = type.substring(0, type.indexOf(10))));
            if (m == null) {
                BentoBox.getInstance().logWarning("Unknown material: " + type);
                return new ItemStack(Material.AIR);
            }
        }
        try {
            c.loadFromString(n);
            return c.getItemStack("is");
        }
        catch (InvalidConfigurationException e) {
            BentoBox.getInstance().logError("Cannot load ItemStack serialized as " + n);
            return new ItemStack(Material.AIR);
        }
    }
}

