/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.mongodb;

import com.google.gson.Gson;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.DatabaseConnector;
import world.bentobox.bentobox.database.json.AbstractJSONDatabaseHandler;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;

public class MongoDBDatabaseHandler<T>
extends AbstractJSONDatabaseHandler<T> {
    private static final String UNIQUEID = "uniqueId";
    private static final String MONGO_ID = "_id";
    private MongoCollection<Document> collection;
    private final DatabaseConnector dbConnecter;

    MongoDBDatabaseHandler(BentoBox plugin, Class<T> type, DatabaseConnector dbConnecter) {
        super(plugin, type, dbConnecter);
        this.dbConnecter = dbConnecter;
        boolean connected = true;
        try {
            MongoDatabase database = (MongoDatabase)dbConnecter.createConnection(this.dataObject);
            if (database == null) {
                plugin.logError("Could not connect to the database. Are the credentials in the config.yml file correct?");
                connected = false;
            } else {
                String newName;
                String oldName = plugin.getSettings().getDatabasePrefix() + type.getCanonicalName();
                if (!oldName.equals(newName = this.getName(plugin, this.dataObject)) && this.collectionExists(database, oldName) && !this.collectionExists(database, newName)) {
                    this.collection = database.getCollection(oldName);
                    this.collection.renameCollection(new MongoNamespace(database.getName(), newName));
                } else {
                    this.collection = database.getCollection(newName);
                }
                IndexOptions indexOptions = new IndexOptions().unique(true);
                this.collection.createIndex(Indexes.text((String)UNIQUEID), indexOptions);
            }
        }
        catch (MongoTimeoutException e) {
            plugin.logError("Could not connect to the database. MongoDB timed out.");
            plugin.logError("Error code: " + e.getCode());
            plugin.logError("Errors: " + String.join((CharSequence)", ", e.getErrorLabels()));
            connected = false;
        }
        catch (MongoClientException e) {
            plugin.logError("Could not connect to the database. An unhandled error occurred.");
            plugin.logStacktrace(e);
            connected = false;
        }
        if (!connected) {
            plugin.logWarning("Disabling BentoBox...");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    private boolean collectionExists(MongoDatabase database, String collectionName) {
        for (String name : database.listCollectionNames()) {
            if (!name.equalsIgnoreCase(collectionName)) continue;
            return true;
        }
        return false;
    }

    private String getName(BentoBox plugin, Class<T> type) {
        return plugin.getSettings().getDatabasePrefix() + (type.getAnnotation(Table.class) == null ? type.getCanonicalName() : type.getAnnotation(Table.class).name());
    }

    @Override
    public List<T> loadObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        Gson gson = this.getGson();
        for (Document document : this.collection.find((Bson)new Document())) {
            String json = JSON.serialize((Object)document);
            json = json.replaceFirst(MONGO_ID, UNIQUEID);
            try {
                list.add(gson.fromJson(json, this.dataObject));
            }
            catch (Exception e) {
                this.plugin.logError("Could not load object :" + e.getMessage());
            }
        }
        return list;
    }

    @Override
    public T loadObject(@NonNull String uniqueId) {
        Document doc = (Document)this.collection.find((Bson)new Document(MONGO_ID, (Object)uniqueId)).limit(1).first();
        Gson gson = this.getGson();
        String json = JSON.serialize((Object)doc).replaceFirst(MONGO_ID, UNIQUEID);
        return (T)gson.fromJson(json, this.dataObject);
    }

    @Override
    public CompletableFuture<Boolean> saveObject(T instance) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        if (instance == null) {
            this.plugin.logError("MongoDB database request to store a null. ");
            completableFuture.complete(false);
            return completableFuture;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            completableFuture.complete(false);
            return completableFuture;
        }
        DataObject dataObj = (DataObject)instance;
        try {
            Gson gson = this.getGson();
            String toStore = gson.toJson(instance);
            toStore = toStore.replaceFirst(UNIQUEID, MONGO_ID);
            Document document = Document.parse((String)toStore);
            Document filter = new Document(MONGO_ID, (Object)dataObj.getUniqueId());
            FindOneAndReplaceOptions options = new FindOneAndReplaceOptions().upsert(true);
            this.collection.findOneAndReplace((Bson)filter, (Object)document, options);
            completableFuture.complete(true);
        }
        catch (Exception e) {
            this.plugin.logError("Could not save object " + instance.getClass().getName() + " " + e.getMessage());
            completableFuture.complete(false);
        }
        return completableFuture;
    }

    @Override
    public void deleteID(String uniqueId) {
        try {
            this.collection.findOneAndDelete((Bson)new Document(MONGO_ID, (Object)uniqueId));
        }
        catch (Exception e) {
            this.plugin.logError("Could not delete object " + this.getName(this.plugin, this.dataObject) + " " + uniqueId + " " + e.getMessage());
        }
    }

    @Override
    public void deleteObject(T instance) {
        if (instance == null) {
            this.plugin.logError("MondDB database request to delete a null. ");
            return;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            return;
        }
        this.deleteID(((DataObject)instance).getUniqueId());
    }

    @Override
    public boolean objectExists(String uniqueId) {
        return this.collection.find((Bson)new Document(MONGO_ID, (Object)uniqueId)).first() != null;
    }

    @Override
    public void close() {
        this.dbConnecter.closeConnection(this.dataObject);
    }
}

