/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.DatabaseConnector;
import world.bentobox.bentobox.database.json.AbstractJSONDatabaseHandler;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.sql.SQLConfiguration;

public class SQLDatabaseHandler<T>
extends AbstractJSONDatabaseHandler<T> {
    protected static final String COULD_NOT_LOAD_OBJECTS = "Could not load objects ";
    protected static final String COULD_NOT_LOAD_OBJECT = "Could not load object ";
    protected DataSource dataSource;
    private SQLConfiguration sqlConfig;

    protected SQLDatabaseHandler(BentoBox plugin, Class<T> type, DatabaseConnector databaseConnector, SQLConfiguration sqlConfiguration) {
        super(plugin, type, databaseConnector);
        this.sqlConfig = sqlConfiguration;
        if (this.setDataSource((DataSource)this.databaseConnector.createConnection(type))) {
            this.createSchema();
        }
    }

    public SQLConfiguration getSqlConfig() {
        return this.sqlConfig;
    }

    public void setSqlConfig(SQLConfiguration sqlConfig) {
        this.sqlConfig = sqlConfig;
    }

    protected void createSchema() {
        if (this.sqlConfig.renameRequired()) {
            String sql = this.sqlConfig.getRenameTableSQL().replace("[oldTableName]", this.sqlConfig.getOldTableName()).replace("[tableName]", this.sqlConfig.getTableName());
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.execute();
            }
            catch (SQLException e) {
                this.plugin.logError("Could not rename " + this.sqlConfig.getOldTableName() + " for data object " + this.dataObject.getCanonicalName() + " " + e.getMessage());
            }
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlConfig.getSchemaSQL());){
            preparedStatement.execute();
        }
        catch (SQLException e) {
            this.plugin.logError("Problem trying to create schema for data object " + this.dataObject.getCanonicalName() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> loadObjects() {
        try (Connection connection = this.dataSource.getConnection();){
            List<T> list;
            block14: {
                Statement preparedStatement = connection.createStatement();
                try {
                    list = this.loadIt(preparedStatement);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return list;
        }
        catch (SQLException e) {
            this.plugin.logError(COULD_NOT_LOAD_OBJECTS + e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<T> loadIt(Statement preparedStatement) {
        ArrayList list = new ArrayList();
        try (ResultSet resultSet = preparedStatement.executeQuery(this.sqlConfig.getLoadObjectsSQL());){
            Gson gson = this.getGson();
            while (resultSet.next()) {
                String json = resultSet.getString("json");
                if (json == null) continue;
                this.getGsonResultSet(gson, json, list);
            }
        }
        catch (Exception e) {
            this.plugin.logError(COULD_NOT_LOAD_OBJECTS + e.getMessage());
        }
        return list;
    }

    private void getGsonResultSet(Gson gson, String json, List<T> list) {
        try {
            Object gsonResult = gson.fromJson(json, this.dataObject);
            if (gsonResult != null) {
                list.add(gsonResult);
            }
        }
        catch (JsonSyntaxException ex) {
            this.plugin.logError(COULD_NOT_LOAD_OBJECT + ex.getMessage());
            this.plugin.logError(json);
        }
    }

    @Override
    public T loadObject(@NonNull String uniqueId) {
        T result = null;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlConfig.getLoadObjectSQL());){
            preparedStatement.setString(1, (String)(this.sqlConfig.isUseQuotes() ? "\"" + uniqueId + "\"" : uniqueId));
            result = this.getObject(uniqueId, preparedStatement);
        }
        catch (SQLException e) {
            this.plugin.logError(COULD_NOT_LOAD_OBJECT + uniqueId + " " + e.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T getObject(@NonNull String uniqueId, PreparedStatement preparedStatement) {
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) return null;
            Gson gson = this.getGson();
            Object object = gson.fromJson(resultSet.getString("json"), this.dataObject);
            return (T)object;
        }
        catch (Exception e) {
            this.plugin.logError(COULD_NOT_LOAD_OBJECT + uniqueId + " " + e.getMessage());
        }
        return null;
    }

    @Override
    public CompletableFuture<Boolean> saveObject(T instance) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        if (instance == null) {
            this.plugin.logError("SQL database request to store a null. ");
            completableFuture.complete(false);
            return completableFuture;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            completableFuture.complete(false);
            return completableFuture;
        }
        String toStore = this.getGson().toJson(instance);
        if (this.plugin.isEnabled()) {
            this.processQueue.add(() -> this.store(completableFuture, instance.getClass().getName(), toStore, this.sqlConfig.getSaveObjectSQL(), true));
        } else {
            this.store(completableFuture, instance.getClass().getName(), toStore, this.sqlConfig.getSaveObjectSQL(), false);
        }
        return completableFuture;
    }

    private void store(CompletableFuture<Boolean> completableFuture, String name, String toStore, String storeSQL, boolean async) {
        if (async && !this.plugin.isEnabled()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(storeSQL);){
            preparedStatement.setString(1, toStore);
            preparedStatement.setString(2, toStore);
            preparedStatement.execute();
            completableFuture.complete(true);
        }
        catch (SQLException e) {
            this.plugin.logError("Could not save object " + name + " " + e.getMessage());
            completableFuture.complete(false);
        }
    }

    @Override
    public void deleteID(String uniqueId) {
        this.processQueue.add(() -> this.delete(uniqueId));
    }

    private void delete(String uniqueId) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlConfig.getDeleteObjectSQL());){
            preparedStatement.setString(1, (String)(this.sqlConfig.isUseQuotes() ? "\"" + uniqueId + "\"" : uniqueId));
            preparedStatement.execute();
        }
        catch (Exception e) {
            this.plugin.logError("Could not delete object " + this.plugin.getSettings().getDatabasePrefix() + this.dataObject.getCanonicalName() + " " + uniqueId + " " + e.getMessage());
        }
    }

    @Override
    public void deleteObject(T instance) {
        if (instance == null) {
            this.plugin.logError("SQL database request to delete a null.");
            return;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            return;
        }
        try {
            Method getUniqueId = this.dataObject.getMethod("getUniqueId", new Class[0]);
            this.deleteID((String)getUniqueId.invoke(instance, new Object[0]));
        }
        catch (Exception e) {
            this.plugin.logError("Could not delete object " + instance.getClass().getName() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean objectExists(String uniqueId) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlConfig.getObjectExistsSQL());){
            preparedStatement.setString(1, (String)(this.sqlConfig.isUseQuotes() ? "\"" + uniqueId + "\"" : uniqueId));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = resultSet.getBoolean(1);
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.logError("Could not check if key exists in database! " + uniqueId + " " + e.getMessage());
        }
        return false;
    }

    @Override
    public void close() {
        this.shutdown = true;
    }

    public boolean setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            this.plugin.logError("Could not connect to the database. Are the credentials in the config.yml file correct?");
            this.plugin.logWarning("Disabling the plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return false;
        }
        this.dataSource = dataSource;
        return true;
    }
}

