/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql.mysql;

import com.zaxxer.hikari.HikariConfig;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.database.DatabaseConnectionSettingsImpl;
import world.bentobox.bentobox.database.sql.SQLDatabaseConnector;

public class MySQLDatabaseConnector
extends SQLDatabaseConnector {
    MySQLDatabaseConnector(@NonNull DatabaseConnectionSettingsImpl dbSettings) {
        super(dbSettings, String.format("jdbc:mysql://%s:%s/%s", dbSettings.getHost(), dbSettings.getPort(), dbSettings.getDatabaseName()));
    }

    @Override
    public HikariConfig createConfig() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("BentoBox MySQL Pool");
        config.setDriverClassName("com.mysql.jdbc.Driver");
        config.setJdbcUrl(this.connectionUrl);
        config.setUsername(this.dbSettings.getUsername());
        config.setPassword(this.dbSettings.getPassword());
        config.addDataSourceProperty("useSSL", (Object)this.dbSettings.isUseSSL());
        config.addDataSourceProperty("characterEncoding", (Object)"utf8");
        config.addDataSourceProperty("encoding", (Object)"UTF-8");
        config.addDataSourceProperty("useUnicode", (Object)"true");
        config.addDataSourceProperty("allowMultiQueries", (Object)"true");
        config.addDataSourceProperty("allowPublicKeyRetrieval", (Object)"true");
        this.dbSettings.getExtraProperties().forEach((arg_0, arg_1) -> ((HikariConfig)config).addDataSourceProperty(arg_0, arg_1));
        config.setMaximumPoolSize(this.dbSettings.getMaxConnections());
        return config;
    }
}

