/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql.postgresql;

import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.DatabaseConnector;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.sql.SQLConfiguration;
import world.bentobox.bentobox.database.sql.SQLDatabaseHandler;

public class PostgreSQLDatabaseHandler<T>
extends SQLDatabaseHandler<T> {
    PostgreSQLDatabaseHandler(BentoBox plugin, Class<T> type, DatabaseConnector databaseConnector) {
        super(plugin, type, databaseConnector, new SQLConfiguration(plugin, type).schema("CREATE TABLE IF NOT EXISTS \"[tableName]\" (uniqueid VARCHAR PRIMARY KEY, json jsonb NOT NULL)").loadObject("SELECT * FROM \"[tableName]\" WHERE uniqueid = ? LIMIT 1").deleteObject("DELETE FROM \"[tableName]\" WHERE uniqueid = ?").saveObject("INSERT INTO \"[tableName]\" (uniqueid, json) VALUES (?, cast(? as json)) ON CONFLICT (uniqueid) DO UPDATE SET json = cast(? as json)").loadObjects("SELECT json FROM \"[tableName]\"").objectExists("SELECT EXISTS(SELECT * FROM \"[tableName]\" WHERE uniqueid = ?)").renameTable("ALTER TABLE IF EXISTS \"[oldTableName]\" RENAME TO \"[tableName]\"").setUseQuotes(false));
    }

    @Override
    public CompletableFuture<Boolean> saveObject(T instance) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        if (instance == null) {
            this.plugin.logError("PostgreSQL database request to store a null. ");
            completableFuture.complete(false);
            return completableFuture;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            completableFuture.complete(false);
            return completableFuture;
        }
        Gson gson = this.getGson();
        String toStore = gson.toJson(instance);
        String uniqueId = ((DataObject)instance).getUniqueId();
        this.processQueue.add(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(this.getSqlConfig().getSaveObjectSQL());){
                preparedStatement.setString(1, uniqueId);
                preparedStatement.setString(2, toStore);
                preparedStatement.setString(3, toStore);
                preparedStatement.execute();
                completableFuture.complete(true);
            }
            catch (SQLException e) {
                this.plugin.logError("Could not save object " + instance.getClass().getName() + " " + e.getMessage());
                completableFuture.complete(false);
            }
        });
        return completableFuture;
    }
}

