/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomStack;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.clicklisteners.CycleClick;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.hooks.BlockInteractListener;

public class ItemsAdderHook
extends Hook {
    public static final Flag ITEMS_ADDER_EXPLOSIONS = new Flag.Builder("ITEMS_ADDER_EXPLOSIONS", Material.TNT).type(Flag.Type.PROTECTION).defaultRank(500).clickHandler(new CycleClick("ITEMS_ADDER_EXPLOSIONS", 0, 1000)).build();
    private final BentoBox plugin;
    private BlockInteractListener listener;

    public ItemsAdderHook(BentoBox plugin) {
        super("ItemsAdder", Material.NETHER_STAR);
        this.plugin = plugin;
    }

    @Override
    public boolean hook() {
        if (Bukkit.getPluginManager().getPlugin("ItemsAdder") == null) {
            return false;
        }
        this.listener = new BlockInteractListener();
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)this.plugin);
        this.plugin.getFlagsManager().registerFlag(ITEMS_ADDER_EXPLOSIONS);
        return true;
    }

    protected BlockInteractListener getListener() {
        return this.listener;
    }

    public void clearBlockInfo(Location location) {
        CustomBlock.remove((Location)location);
    }

    public static Optional<String> getNamespacedId(ItemStack myItemStack) {
        CustomStack stack = CustomStack.byItemStack((ItemStack)myItemStack);
        return Optional.ofNullable(stack == null ? null : stack.getNamespacedID());
    }

    public static Set<String> getAllBlocks() {
        return CustomBlock.getNamespacedIdsInRegistry();
    }

    public static String getInCustomRegion(Location loc) {
        return CustomBlock.Advanced.getInCustomRegion((Location)loc);
    }

    public static Optional<ItemStack> getItemStack(String namespacedId) {
        CustomBlock cb = ItemsAdderHook.getInstance(namespacedId);
        if (cb == null) {
            return Optional.empty();
        }
        ItemStack item = cb.getItemStack();
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)cb.getDisplayName()));
        item.setItemMeta(meta);
        return Optional.of(item);
    }

    public static void place(String namespacedId, Location loc) {
        CustomBlock.place((String)namespacedId, (Location)loc);
    }

    public static void deleteAllCustomBlocksInChunk(Chunk chunk) {
        CustomBlock.Advanced.deleteAllCustomBlocksInChunk((Chunk)chunk);
    }

    public @Nullable List<Location> getAllBlocksLocationsList(Chunk chunk) {
        return CustomBlock.Advanced.getAllBlocksLocationsList((Chunk)chunk);
    }

    public @Nullable Map<Location, String> getAllBlocksLocations(Chunk chunk) {
        return CustomBlock.Advanced.getAllBlocksLocations((Chunk)chunk);
    }

    public void runActionOnBlocks(Chunk chunk, BiConsumer<String, Location> action) {
        CustomBlock.Advanced.runActionOnBlocks((Chunk)chunk, action);
    }

    public static boolean isInRegistry(String namespacedId) {
        return CustomBlock.isInRegistry((String)namespacedId);
    }

    public static @NonNull CustomBlock getInstance(String namespacedID) {
        return CustomBlock.getInstance((String)namespacedID);
    }
}

