/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;

public class MythicMobsHook
extends Hook {
    public MythicMobsHook() {
        super("MythicMobs", Material.CREEPER_HEAD);
    }

    public boolean isMythicMob(Entity bukkitEntity) {
        return MythicBukkit.inst().getMobManager().isMythicMob(bukkitEntity);
    }

    public BlueprintEntity.MythicMobRecord getMythicMob(Entity bukkitEntity) {
        ActiveMob mm = MythicBukkit.inst().getMobManager().getActiveMob(bukkitEntity.getUniqueId()).orElse(null);
        if (mm != null) {
            return new BlueprintEntity.MythicMobRecord(mm.getMobType(), mm.getDisplayName(), mm.getLevel(), mm.getPower(), mm.getStance());
        }
        return null;
    }

    @Override
    public boolean hook() {
        return true;
    }

    @Override
    public String getFailureCause() {
        return null;
    }

    public boolean spawnMythicMob(BlueprintEntity.MythicMobRecord mmr, Location spawnLocation) {
        if (!this.isPluginAvailable()) {
            return false;
        }
        return MythicBukkit.inst().getMobManager().getMythicMob(mmr.type()).map(mob -> {
            Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> {
                ActiveMob activeMob = mob.spawn(BukkitAdapter.adapt((Location)spawnLocation), mmr.level());
                activeMob.setDisplayName(mmr.displayName());
                activeMob.setPower(mmr.power());
                activeMob.setStance(mmr.stance());
            }, 40L);
            return true;
        }).orElse(false);
    }
}

