/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.RegisteredServiceProvider;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.api.user.User;

public class VaultHook
extends Hook {
    private static final String AMOUNT_MUST_BE_POSITIVE = "Amount must be positive.";
    private static final String PLAYER_OR_OFFLINEPLAYER_REQUIRED = "User must be a Player or an OfflinePlayer";
    private Economy economy;

    public VaultHook() {
        super("Vault", Material.GOLD_NUGGET);
    }

    @Override
    public boolean hook() {
        try {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return false;
            }
            this.economy = (Economy)rsp.getProvider();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getFailureCause() {
        return "no plugin supporting economy has been found";
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public String format(double amount) {
        return this.economy.format(amount);
    }

    public double getBalance(User user) {
        return this.getBalance(user, user.getWorld());
    }

    public double getBalance(User user, World world) {
        if (!user.isOfflinePlayer()) {
            return 0.0;
        }
        if (world == null) {
            return this.economy.getBalance(user.getOfflinePlayer());
        }
        return this.economy.getBalance(user.getOfflinePlayer(), world.getName());
    }

    public EconomyResponse withdraw(User user, double amount) {
        return this.withdraw(user, amount, user.getWorld());
    }

    public EconomyResponse withdraw(User user, double amount, World world) {
        if (!user.isOfflinePlayer()) {
            throw new IllegalArgumentException(PLAYER_OR_OFFLINEPLAYER_REQUIRED);
        }
        if (amount < 0.0) {
            throw new IllegalArgumentException(AMOUNT_MUST_BE_POSITIVE);
        }
        if (world == null) {
            return this.economy.withdrawPlayer(user.getOfflinePlayer(), amount);
        }
        EconomyResponse response = this.economy.withdrawPlayer(user.getOfflinePlayer(), world.getName(), amount);
        if (response == null || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED) {
            return this.economy.withdrawPlayer(user.getOfflinePlayer(), amount);
        }
        return response;
    }

    public EconomyResponse deposit(User user, double amount) {
        return this.deposit(user, amount, user.getWorld());
    }

    public EconomyResponse deposit(User user, double amount, World world) {
        if (!user.isOfflinePlayer()) {
            throw new IllegalArgumentException(PLAYER_OR_OFFLINEPLAYER_REQUIRED);
        }
        if (amount < 0.0) {
            throw new IllegalArgumentException(AMOUNT_MUST_BE_POSITIVE);
        }
        if (world == null) {
            return this.economy.depositPlayer(user.getOfflinePlayer(), amount);
        }
        EconomyResponse response = this.economy.depositPlayer(user.getOfflinePlayer(), world.getName(), amount);
        if (response == null || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED) {
            return this.economy.depositPlayer(user.getOfflinePlayer(), amount);
        }
        return response;
    }

    public boolean has(User user, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException(AMOUNT_MUST_BE_POSITIVE);
        }
        return user.isOfflinePlayer() && this.economy.has(user.getOfflinePlayer(), amount);
    }

    public boolean has(User user, double amount, World world) {
        if (amount < 0.0) {
            throw new IllegalArgumentException(AMOUNT_MUST_BE_POSITIVE);
        }
        if (!user.isOfflinePlayer()) {
            throw new IllegalArgumentException(PLAYER_OR_OFFLINEPLAYER_REQUIRED);
        }
        if (world == null) {
            return this.economy.has(user.getOfflinePlayer(), amount);
        }
        return this.economy.has(user.getOfflinePlayer(), world.getName(), amount);
    }
}

