/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lol.pyr.znpcsplus.api.NpcApiProvider;
import lol.pyr.znpcsplus.api.npc.NpcEntry;
import lol.pyr.znpcsplus.api.npc.NpcRegistry;
import lol.pyr.znpcsplus.util.NpcLocation;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.NPCHook;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;
import world.bentobox.bentobox.util.Util;

public class ZNPCsPlusHook
extends NPCHook {
    private static final String VERSION = "2.0.0-SNAPSHOT";

    public ZNPCsPlusHook() {
        super("ZNPCsPlus", Material.PLAYER_HEAD);
    }

    String serializeNPC(NpcEntry entry, Vector origin) {
        String result = ((YamlConfiguration)NpcApiProvider.get().getNpcSerializerRegistry().getSerializer(YamlConfiguration.class).serialize(entry)).saveToString();
        return result;
    }

    @Override
    public boolean spawnNpc(String yaml, Location pos) throws InvalidConfigurationException {
        YamlConfiguration yaml2 = new YamlConfiguration();
        yaml2.loadFromString(yaml);
        NpcEntry entry = NpcApiProvider.get().getNpcSerializerRegistry().getSerializer(YamlConfiguration.class).deserialize((Object)yaml2);
        NpcLocation loc = new NpcLocation(pos);
        entry.getNpc().setLocation(loc);
        NpcApiProvider.get().getNpcRegistry().register(entry);
        return true;
    }

    @Override
    public boolean hook() {
        boolean hooked = this.isPluginAvailable();
        String version = this.getPlugin().getDescription().getVersion();
        if (!Util.isVersionCompatible(version, VERSION)) {
            return false;
        }
        if (!hooked) {
            BentoBox.getInstance().logError("Could not hook into FancyNpcs");
        }
        return hooked;
    }

    @Override
    public String getFailureCause() {
        return "ZNPCsPlus version 2.0.0-SNAPSHOT required or later. You are running " + this.getPlugin().getDescription().getVersion();
    }

    @Override
    public Map<? extends Vector, ? extends List<BlueprintEntity>> getNpcsInArea(World world, List<Vector> vectorsToCopy, @Nullable Vector origin) {
        HashMap<Vector, List> bpEntities = new HashMap<Vector, List>();
        for (NpcEntry npcEntry : NpcApiProvider.get().getNpcRegistry().getAll()) {
            NpcLocation npcLocation = npcEntry.getNpc().getLocation();
            Vector loc = new Vector(npcLocation.getBlockX(), npcLocation.getBlockY(), npcLocation.getBlockZ());
            if (!npcEntry.getNpc().getWorld().equals((Object)world) || !vectorsToCopy.contains(loc)) continue;
            BlueprintEntity cit = new BlueprintEntity();
            cit.setNpc(this.serializeNPC(npcEntry, origin));
            List entities = bpEntities.getOrDefault(loc, new ArrayList());
            entities.add(cit);
            Vector origin2 = origin == null ? new Vector(0, 0, 0) : origin;
            int x = loc.getBlockX() - origin2.getBlockX();
            int y = loc.getBlockY() - origin2.getBlockY();
            int z = loc.getBlockZ() - origin2.getBlockZ();
            Vector pos = new Vector(x, y, z);
            bpEntities.put(pos, entities);
        }
        return bpEntities;
    }

    public List<String> getNPCsInChunk(Chunk chunk) {
        return NpcApiProvider.get().getNpcRegistry().getAll().stream().filter(npc -> npc.getNpc().getWorld().equals((Object)chunk.getWorld())).filter(npc -> npc.getNpc().getLocation().toBukkitLocation(chunk.getWorld()).getChunk().equals((Object)chunk)).map(npc -> npc.getId()).toList();
    }

    @Override
    public void removeNPCsInChunk(Chunk chunk) {
        this.getNPCsInChunk(chunk).forEach(arg_0 -> ((NpcRegistry)NpcApiProvider.get().getNpcRegistry()).delete(arg_0));
    }
}

