/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class StandardSpawnProtectionListener
implements Listener {
    private static final String SPAWN_PROTECTED = "protection.spawn-protected";
    private final BentoBox plugin;

    public StandardSpawnProtectionListener(@NonNull BentoBox plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        if (this.noAction(e.getPlayer())) {
            return;
        }
        if (this.atSpawn(e.getBlock().getLocation())) {
            User user = User.getInstance(e.getPlayer());
            user.sendMessage(SPAWN_PROTECTED, "[description]", user.getTranslation(Flags.PLACE_BLOCKS.getHintReference(), new String[0]));
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (this.noAction(e.getPlayer())) {
            return;
        }
        if (this.atSpawn(e.getBlock().getLocation())) {
            User user = User.getInstance(e.getPlayer());
            user.sendMessage(SPAWN_PROTECTED, "[description]", user.getTranslation(Flags.BREAK_BLOCKS.getHintReference(), new String[0]));
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent e) {
        if (!this.plugin.getIWM().inWorld(Util.getWorld(e.getLocation().getWorld())) || this.plugin.getIWM().isIslandNether(e.getLocation().getWorld()) || this.plugin.getIWM().isIslandEnd(e.getLocation().getWorld())) {
            return;
        }
        e.blockList().removeIf(b -> this.atSpawn(b.getLocation()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent e) {
        if (this.noAction(e.getPlayer())) {
            return;
        }
        if (this.atSpawn(e.getBlockClicked().getLocation())) {
            User user = User.getInstance(e.getPlayer());
            user.sendMessage(SPAWN_PROTECTED, "[description]", user.getTranslation(Flags.BUCKET.getHintReference(), new String[0]));
            e.setCancelled(true);
        }
    }

    private boolean atSpawn(@NonNull Location location) {
        if (this.plugin.getIWM().getWorldSettings(location.getWorld()).isMakeNetherPortals()) {
            return false;
        }
        Vector p = location.toVector().multiply(new Vector(1, 0, 1));
        Vector spawn = location.getWorld().getSpawnLocation().toVector().multiply(new Vector(1, 0, 1));
        int radius = this.plugin.getIWM().getNetherSpawnRadius(location.getWorld());
        Vector diff = p.subtract(spawn);
        return Math.abs(diff.getBlockX()) <= radius && Math.abs(diff.getBlockZ()) <= radius;
    }

    private boolean noAction(@NonNull Player player) {
        return player.isOp() || player.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL) || !this.plugin.getIWM().inWorld(Util.getWorld(player.getWorld())) || player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && this.plugin.getIWM().isNetherIslands(player.getWorld()) || player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && this.plugin.getIWM().getWorldSettings(player.getWorld()).isMakeNetherPortals() || player.getWorld().getEnvironment().equals((Object)World.Environment.THE_END) && this.plugin.getIWM().isEndIslands(player.getWorld());
    }
}

