/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;

public class PhysicalInteractionListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.PHYSICAL) || e.getClickedBlock() == null) {
            return;
        }
        if (Tag.PRESSURE_PLATES.isTagged((Keyed)e.getClickedBlock().getType())) {
            this.checkIsland((Event)e, e.getPlayer(), e.getPlayer().getLocation(), Flags.PRESSURE_PLATE);
            return;
        }
        if (e.getClickedBlock().getType() == Material.FARMLAND) {
            this.checkIsland((Event)e, e.getPlayer(), e.getPlayer().getLocation(), Flags.CROP_TRAMPLE);
        } else if (e.getClickedBlock().getType() == Material.TURTLE_EGG) {
            this.checkIsland((Event)e, e.getPlayer(), e.getPlayer().getLocation(), Flags.TURTLE_EGGS);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onProjectileHit(EntityInteractEvent e) {
        Projectile p;
        Entity entity = e.getEntity();
        if (entity instanceof Projectile && (entity = (p = (Projectile)entity).getShooter()) instanceof Player) {
            Player player = (Player)entity;
            this.checkBlocks((Event)e, player, e.getBlock());
        }
    }

    private boolean checkBlocks(Event e, Player player, Block block) {
        Map<Tag, Flag> TAG_TO_FLAG = Map.of(Tag.WOODEN_BUTTONS, Flags.BUTTON, Tag.PRESSURE_PLATES, Flags.PRESSURE_PLATE, Tag.FENCE_GATES, Flags.GATE, Tag.DOORS, Flags.DOOR, Tag.CANDLE_CAKES, Flags.CANDLES, Tag.CANDLES, Flags.CANDLES);
        Map<Material, Flag> MAT_TO_FLAG = Map.of(Material.LEVER, Flags.LEVER, Material.TRIPWIRE, Flags.REDSTONE, Material.TARGET, Flags.REDSTONE, Material.DECORATED_POT, Flags.BREAK_BLOCKS);
        boolean result = TAG_TO_FLAG.entrySet().stream().filter(entry -> ((Tag)entry.getKey()).isTagged((Keyed)block.getType())).findFirst().map(entry -> this.checkIsland(e, player, block.getLocation(), (Flag)entry.getValue())).orElse(true);
        if (result && MAT_TO_FLAG.containsKey(block.getType())) {
            result = this.checkIsland(e, player, block.getLocation(), MAT_TO_FLAG.get(block.getType()));
        }
        return result;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onProjectileExplode(EntityExplodeEvent e) {
        Projectile p;
        Entity entity = e.getEntity();
        if (entity instanceof Projectile && (entity = (p = (Projectile)entity).getShooter()) instanceof Player) {
            Player player = (Player)entity;
            ArrayList<Block> blocksToRemove = new ArrayList<Block>();
            for (Block b : e.blockList()) {
                if (this.checkBlocks((Event)e, player, b)) continue;
                blocksToRemove.add(b);
            }
            e.blockList().removeAll(blocksToRemove);
        }
    }
}

