/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import world.bentobox.bentobox.api.events.BentoBoxReadyEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.database.objects.Island;

public class GeoLimitMobsListener
extends FlagListener {
    private final Map<Entity, Island> mobSpawnTracker = new WeakHashMap<Entity, Island>();

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPluginReady(BentoBoxReadyEvent event) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.getPlugin(), () -> {
            this.mobSpawnTracker.entrySet().stream().filter(e -> !((Island)e.getValue()).onIsland(((Entity)e.getKey()).getLocation())).map(Map.Entry::getKey).forEach(Entity::remove);
            this.mobSpawnTracker.keySet().removeIf(e -> e == null || e.isDead());
        }, 20L, 20L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onMobSpawn(CreatureSpawnEvent e) {
        if (this.getIWM().inWorld(e.getLocation()) && this.getIWM().getGeoLimitSettings(e.getLocation().getWorld()).contains(e.getEntityType().name())) {
            this.getIslands().getIslandAt(e.getLocation()).ifPresent(i -> this.mobSpawnTracker.put((Entity)e.getEntity(), (Island)i));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onMobDeath(EntityDeathEvent e) {
        this.mobSpawnTracker.remove(e.getEntity());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onProjectileExplode(ExplosionPrimeEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Projectile) {
            Entity shooter;
            ProjectileSource source;
            Projectile projectile = (Projectile)entity;
            if (this.getIWM().inWorld(e.getEntity().getLocation()) && (source = projectile.getShooter()) instanceof Entity && this.mobSpawnTracker.containsKey(shooter = (Entity)source) && !this.mobSpawnTracker.get(shooter).onIsland(e.getEntity().getLocation())) {
                e.getEntity().remove();
                e.setCancelled(true);
            }
        }
    }
}

