/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.Optional;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.raid.RaidTriggerEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class VisitorsStartingRaidListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onRaidTrigger(RaidTriggerEvent event) {
        World world = Util.getWorld(event.getWorld());
        if (!this.getIWM().inWorld(world) || Flags.VISITOR_TRIGGER_RAID.isSetForWorld(world)) {
            this.report(User.getInstance(event.getPlayer()), (Event)event, event.getPlayer().getLocation(), Flags.VISITOR_TRIGGER_RAID, FlagListener.Why.SETTING_ALLOWED_IN_WORLD);
            return;
        }
        Optional<Island> island = this.getIslands().getProtectedIslandAt(event.getPlayer().getLocation());
        if (island.isPresent() && !island.get().inTeam(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            this.report(User.getInstance(event.getPlayer()), (Event)event, event.getPlayer().getLocation(), Flags.VISITOR_TRIGGER_RAID, FlagListener.Why.SETTING_NOT_ALLOWED_IN_WORLD);
        }
    }
}

