/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.permissions.DefaultPermissions;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.AddonClassLoader;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.addons.Pladdon;
import world.bentobox.bentobox.api.addons.exceptions.InvalidAddonDescriptionException;
import world.bentobox.bentobox.api.addons.exceptions.InvalidAddonFormatException;
import world.bentobox.bentobox.api.addons.exceptions.InvalidAddonInheritException;
import world.bentobox.bentobox.api.configuration.ConfigObject;
import world.bentobox.bentobox.api.events.addon.AddonEvent;
import world.bentobox.bentobox.commands.BentoBoxCommand;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.util.Util;

public class AddonsManager {
    private static final String DEFAULT = ".default";
    private static final String GAMEMODE = "[gamemode].";
    @NotNull
    private static final String BENTOBOX = "/bentobox";
    private final @NonNull List<Addon> addons;
    private final @NonNull Map<@NonNull Addon, @Nullable AddonClassLoader> loaders;
    private final @NonNull Map<@NonNull Addon, @Nullable Plugin> pladdons;
    private final @NonNull Map<String, Class<?>> classes;
    private final BentoBox plugin;
    private final @NonNull Map<@NonNull String, @Nullable GameModeAddon> worldNames;
    private final @NonNull Map<@NonNull Addon, @NonNull List<Listener>> listeners;

    public AddonsManager(@NonNull BentoBox plugin) {
        this.plugin = plugin;
        this.addons = new ArrayList<Addon>();
        this.loaders = new HashMap<Addon, AddonClassLoader>();
        this.pladdons = new HashMap<Addon, Plugin>();
        this.classes = new HashMap();
        this.listeners = new HashMap<Addon, List<Listener>>();
        this.worldNames = new HashMap<String, GameModeAddon>();
    }

    public void registerAddon(Plugin parent, Addon addon) {
        this.plugin.log("Registering " + parent.getDescription().getName());
        InputStream resource = parent.getResource("addon.yml");
        if (resource == null) {
            this.plugin.logError("Failed to register addon: no addon.yml found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource));){
            this.setAddonFile(parent, addon);
            YamlConfiguration data = new YamlConfiguration();
            data.load((Reader)reader);
            addon.setDescription(AddonClassLoader.asDescription(data));
            addon.setDataFolder(parent.getDataFolder());
            this.initializeAddon(addon);
            this.sortAddons();
        }
        catch (Exception e) {
            this.plugin.logError("Failed to register addon: " + String.valueOf(e));
        }
    }

    private void setAddonFile(Plugin parent, Addon addon) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getFileMethod = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
        getFileMethod.setAccessible(true);
        addon.setFile((File)getFileMethod.invoke((Object)parent, new Object[0]));
    }

    public void loadAddons() {
        this.plugin.log("Loading addons...");
        File f = new File(this.plugin.getDataFolder(), "addons");
        if (!f.exists() && !f.mkdirs()) {
            this.plugin.logError("Cannot create addons folder!");
            return;
        }
        Arrays.stream(Objects.requireNonNull(f.listFiles())).filter(x -> !x.isDirectory() && x.getName().endsWith(".jar") && !x.getName().startsWith("._")).forEach(this::loadAddon);
        this.plugin.log("Loaded " + this.getLoadedAddons().size() + " addons.");
        if (!this.getLoadedAddons().isEmpty()) {
            this.sortAddons();
        }
    }

    private void loadAddon(@NonNull File f) {
        PladdonData result = new PladdonData(null, false);
        try (JarFile jar = new JarFile(f);){
            YamlConfiguration data = this.addonDescription(jar);
            String main = data.getString("main");
            if (main != null && this.getAddonByMainClassName(main).isPresent()) {
                this.getAddonByMainClassName(main).ifPresent(a -> {
                    this.plugin.logError("Duplicate addon! Addon " + a.getDescription().getName() + " " + a.getDescription().getVersion() + " has already been loaded!");
                    this.plugin.logError("Remove the duplicate and restart!");
                });
                return;
            }
            result = this.loadPladdon(data, f);
        }
        catch (Exception e) {
            this.plugin.logError("Could not load addon '" + f.getName() + "'. Error is: " + e.getMessage());
            this.plugin.logStacktrace(e);
            return;
        }
        if (result.success) {
            result.addon.setDataFolder(new File(f.getParent(), result.addon.getDescription().getName()));
            result.addon.setFile(f);
            this.initializeAddon(result.addon);
        }
    }

    private PladdonData loadPladdon(YamlConfiguration data, @NonNull File f) throws InvalidAddonInheritException, MalformedURLException, InvalidAddonDescriptionException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InvalidDescriptionException {
        Addon addon;
        try {
            Plugin pladdon = Bukkit.getPluginManager().loadPlugin(f);
            if (pladdon != null && pladdon instanceof Pladdon) {
                Pladdon pl = (Pladdon)pladdon;
                addon = pl.getAddon();
                addon.setDescription(AddonClassLoader.asDescription(data));
                pl.setEnabled();
                this.pladdons.put(addon, pladdon);
            } else {
                BentoBox.getInstance().log("Failed to load " + f.getName() + ", trying to load it as a BentoBox addon");
                AddonClassLoader addonClassLoader = new AddonClassLoader(this, data, f, this.getClass().getClassLoader());
                addon = addonClassLoader.getAddon();
                this.loaders.put(addon, addonClassLoader);
            }
        }
        catch (Exception ex) {
            AddonClassLoader addonClassLoader = new AddonClassLoader(this, data, f, this.getClass().getClassLoader());
            addon = addonClassLoader.getAddon();
            this.loaders.put(addon, addonClassLoader);
        }
        return new PladdonData(addon, true);
    }

    private void initializeAddon(Addon addon) {
        this.plugin.getLocalesManager().copyLocalesFromAddonJar(addon);
        this.plugin.getLocalesManager().loadLocalesFromFile(addon.getDescription().getName());
        new AddonEvent().builder().addon(addon).reason(AddonEvent.Reason.LOAD).build();
        this.addons.remove(addon);
        this.addons.add(addon);
        if (!this.isAddonCompatibleWithBentoBox(addon)) {
            this.plugin.logError("Cannot load " + addon.getDescription().getName() + " because it requires BentoBox version " + addon.getDescription().getApiVersion() + " or greater.");
            this.plugin.logError("NOTE: Please update BentoBox.");
            addon.setState(Addon.State.INCOMPATIBLE);
            return;
        }
        try {
            addon.setState(Addon.State.LOADED);
            addon.onLoad();
            if (addon instanceof GameModeAddon) {
                GameModeAddon gameMode = (GameModeAddon)addon;
                if (!addon.getState().equals((Object)Addon.State.DISABLED) && !gameMode.getWorldSettings().getWorldName().isEmpty()) {
                    this.worldNames.put(gameMode.getWorldSettings().getWorldName().toLowerCase(Locale.ENGLISH), gameMode);
                }
            }
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            this.handleAddonIncompatibility(addon, e);
        }
        catch (Exception e) {
            this.handleAddonError(addon, e);
        }
    }

    public void enableAddons() {
        if (this.getLoadedAddons().isEmpty()) {
            return;
        }
        this.plugin.log("Enabling game mode addons...");
        this.getLoadedAddons().stream().filter(a -> !a.getState().equals((Object)Addon.State.DISABLED)).filter(GameModeAddon.class::isInstance).forEach(this::enableAddon);
        this.plugin.log("Enabling other addons...");
        this.getLoadedAddons().stream().filter(a -> !a.getState().equals((Object)Addon.State.DISABLED)).filter(g -> !(g instanceof GameModeAddon)).forEach(this::enableAddon);
        this.getEnabledAddons().forEach(this::setPerms);
        this.plugin.log("Addons successfully enabled.");
    }

    boolean setPerms(Addon addon) {
        ConfigurationSection perms = addon.getDescription().getPermissions();
        if (perms == null) {
            return false;
        }
        for (String perm : perms.getKeys(true)) {
            if (!perms.contains(perm + DEFAULT) || !perms.contains(perm + ".description")) continue;
            try {
                this.registerPermission(perms, perm);
            }
            catch (InvalidAddonDescriptionException e) {
                this.plugin.logError("Addon " + addon.getDescription().getName() + ": " + e.getMessage());
            }
        }
        return true;
    }

    void registerPermission(ConfigurationSection perms, String perm) throws InvalidAddonDescriptionException {
        String name = perms.getString(perm + DEFAULT);
        if (name == null) {
            throw new InvalidAddonDescriptionException("Permission default is invalid in addon.yml: " + perm + DEFAULT);
        }
        PermissionDefault pd = PermissionDefault.getByName((String)name);
        if (pd == null) {
            throw new InvalidAddonDescriptionException("Permission default is invalid in addon.yml: " + perm + DEFAULT);
        }
        String desc = perms.getString(perm + ".description");
        if (perm.contains(GAMEMODE)) {
            this.getGameModeAddons().stream().map(Addon::getPermissionPrefix).forEach(p -> DefaultPermissions.registerPermission((String)perm.replace(GAMEMODE, (CharSequence)p), (String)desc, (PermissionDefault)pd));
        } else {
            DefaultPermissions.registerPermission((String)perm, (String)desc, (PermissionDefault)pd);
        }
    }

    private void enableAddon(Addon addon) {
        this.plugin.log("Enabling " + addon.getDescription().getName() + " (" + addon.getDescription().getVersion() + ")...");
        try {
            GameModeAddon gameMode;
            if (addon instanceof GameModeAddon) {
                gameMode = (GameModeAddon)addon;
                gameMode.createWorlds();
                if (gameMode.isUsesNewChunkGeneration()) {
                    this.createSeedWorlds(gameMode);
                }
                this.plugin.getIWM().addGameMode(gameMode);
                this.plugin.getBlueprintsManager().extractDefaultBlueprints(gameMode);
                this.plugin.getBlueprintsManager().loadBlueprintBundles(gameMode);
            }
            addon.onEnable();
            if (addon.getState().equals((Object)Addon.State.DISABLED)) {
                this.plugin.log(addon.getDescription().getName() + " is disabled.");
                return;
            }
            if (addon instanceof GameModeAddon) {
                gameMode = (GameModeAddon)addon;
                gameMode.getPlayerCommand().ifPresent(c -> c.setWorld(gameMode.getOverWorld()));
                gameMode.getAdminCommand().ifPresent(c -> c.setWorld(gameMode.getOverWorld()));
            }
            new AddonEvent().builder().addon(addon).reason(AddonEvent.Reason.ENABLE).build();
            addon.setState(Addon.State.ENABLED);
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            this.handleAddonIncompatibility(addon, e);
        }
        catch (Exception e) {
            this.handleAddonError(addon, e);
        }
    }

    private void createSeedWorlds(GameModeAddon gameMode) {
        if (gameMode.getOverWorld() != null) {
            this.seedWorld(gameMode, gameMode.getOverWorld());
        }
        if (gameMode.getNetherWorld() != null) {
            this.seedWorld(gameMode, gameMode.getNetherWorld());
        }
        if (gameMode.getEndWorld() != null) {
            this.seedWorld(gameMode, gameMode.getEndWorld());
        }
    }

    public void removeSeedWorlds() {
        this.plugin.log("Removing temporary seed worlds...");
        this.getGameModeAddons().stream().filter(GameModeAddon::isUsesNewChunkGeneration).forEach(gameMode -> {
            this.plugin.log("Removing " + gameMode.getDescription().getName());
            if (gameMode.getOverWorld() != null) {
                this.plugin.log("Removing " + gameMode.getOverWorld().getName() + BENTOBOX);
                this.removeSeedWorld(gameMode.getOverWorld().getName() + BENTOBOX);
            }
            if (gameMode.getNetherWorld() != null) {
                this.removeSeedWorld(gameMode.getNetherWorld().getName() + BENTOBOX);
            }
            if (gameMode.getEndWorld() != null) {
                this.removeSeedWorld(gameMode.getEndWorld().getName() + BENTOBOX);
            }
        });
        this.plugin.log("Removed temporary seed worlds.");
    }

    private void removeSeedWorld(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null || !world.getName().endsWith(BENTOBOX)) {
            return;
        }
        for (Player player : world.getPlayers()) {
            player.teleport(((World)Bukkit.getWorlds().getFirst()).getSpawnLocation());
        }
        boolean success = Bukkit.unloadWorld((World)world, (boolean)false);
        if (!success) {
            this.plugin.logWarning("Failed to unload seed world: " + world.getName());
        }
        File path = new File(Bukkit.getWorldContainer(), world.getName());
        this.deleteWorldFolder(path);
    }

    private void deleteWorldFolder(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.deleteWorldFolder(file);
                }
            }
            if (!path.delete()) {
                this.plugin.logWarning("Failed to delete: " + path.getAbsolutePath());
            }
        }
    }

    private void seedWorld(GameModeAddon gameMode, @NonNull World world) {
        WorldCreator wc = WorldCreator.name((String)(world.getName() + BENTOBOX)).type(WorldType.FLAT).environment(world.getEnvironment()).seed(world.getSeed());
        World w = gameMode.getWorldSettings().isUseOwnGenerator() ? wc.createWorld() : wc.generator(world.getGenerator()).createWorld();
        w.setDifficulty(Difficulty.PEACEFUL);
        this.plugin.getIWM().addWorld(w, gameMode);
    }

    private void handleAddonIncompatibility(@NonNull Addon addon, LinkageError e) {
        addon.setState(Addon.State.INCOMPATIBLE);
        this.plugin.logWarning("Skipping " + addon.getDescription().getName() + " as it is incompatible with the current version of BentoBox or of server software...");
        this.plugin.logWarning("NOTE: The addon is referring to no longer existing classes.");
        this.plugin.logWarning("NOTE: DO NOT report this as a bug from BentoBox.");
        StringBuilder a = new StringBuilder();
        addon.getDescription().getAuthors().forEach(author -> a.append((String)author).append(" "));
        this.plugin.logError("Please report this stack trace to the addon's author(s): " + String.valueOf(a));
        this.plugin.logStacktrace(e);
    }

    private boolean isAddonCompatibleWithBentoBox(@NonNull Addon addon) {
        String v = this.plugin.getDescription().getVersion();
        return this.isAddonCompatibleWithBentoBox(addon, v);
    }

    boolean isAddonCompatibleWithBentoBox(@NonNull Addon addon, String pluginVersion) {
        String[] apiVersion = addon.getDescription().getApiVersion().split("\\D");
        String[] bentoboxVersion = pluginVersion.split("\\D");
        for (int i = 0; i < apiVersion.length; ++i) {
            int apiNumber;
            int bentoboxNumber = 0;
            if (i < bentoboxVersion.length && Util.isInteger(bentoboxVersion[i], false)) {
                bentoboxNumber = Integer.parseInt(bentoboxVersion[i]);
            }
            int n = apiNumber = Util.isInteger(apiVersion[i], false) ? Integer.parseInt(apiVersion[i]) : -1;
            if (bentoboxNumber > apiNumber) {
                return true;
            }
            if (bentoboxNumber >= apiNumber) continue;
            return false;
        }
        return true;
    }

    private void handleAddonError(@NonNull Addon addon, @NonNull Throwable throwable) {
        addon.setState(Addon.State.ERROR);
        this.plugin.logError("Skipping " + addon.getDescription().getName() + " due to an unhandled exception...");
        this.plugin.logStacktrace(throwable);
    }

    public void reloadAddons() {
        this.disableAddons();
        new BentoBoxCommand();
        this.loadAddons();
        this.enableAddons();
    }

    public void disableAddons() {
        if (!this.getEnabledAddons().isEmpty()) {
            this.plugin.log("Disabling addons...");
            this.getEnabledAddons().stream().filter(addon -> !this.pladdons.containsKey(addon)).forEach(this::disable);
            this.plugin.log("Addons successfully disabled.");
        }
        this.plugin.getCommandsManager().unregisterCommands();
        this.removeSeedWorlds();
        this.listeners.clear();
        this.pladdons.clear();
        this.addons.clear();
        this.loaders.clear();
        this.classes.clear();
    }

    public <T extends Addon> @NonNull Optional<T> getAddonByName(@NonNull String name) {
        return this.addons.stream().filter(a -> a.getDescription().getName().equalsIgnoreCase(name)).map(a -> a).findFirst();
    }

    public <T extends Addon> @NonNull Optional<T> getAddonByMainClassName(@NonNull String name) {
        return this.addons.stream().filter(a -> a.getDescription().getMain().equalsIgnoreCase(name)).map(a -> a).findFirst();
    }

    private @NonNull YamlConfiguration addonDescription(@NonNull JarFile jar) throws InvalidAddonFormatException, IOException, InvalidConfigurationException {
        JarEntry entry = jar.getJarEntry("addon.yml");
        if (entry == null) {
            throw new InvalidAddonFormatException("Addon '" + jar.getName() + "' doesn't contains addon.yml file");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
        YamlConfiguration data = new YamlConfiguration();
        data.load((Reader)reader);
        reader.close();
        return data;
    }

    public @NonNull List<Addon> getAddons() {
        return this.addons;
    }

    public @NonNull List<GameModeAddon> getGameModeAddons() {
        return this.getEnabledAddons().stream().filter(GameModeAddon.class::isInstance).map(GameModeAddon.class::cast).toList();
    }

    public @NonNull List<Addon> getLoadedAddons() {
        return this.addons.stream().filter(addon -> addon.getState().equals((Object)Addon.State.LOADED)).toList();
    }

    public @NonNull List<Addon> getEnabledAddons() {
        return this.addons.stream().filter(addon -> addon.getState().equals((Object)Addon.State.ENABLED)).toList();
    }

    public @Nullable AddonClassLoader getLoader(@NonNull Addon addon) {
        return this.loaders.get(addon);
    }

    public @Nullable Class<?> getClassByName(@NonNull String name) {
        try {
            return this.classes.getOrDefault(name, this.loaders.values().stream().filter(Objects::nonNull).map(l -> l.findClass(name, false)).filter(Objects::nonNull).findFirst().orElse(null));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setClass(@NonNull String name, @NonNull Class<?> clazz) {
        this.classes.putIfAbsent(name, clazz);
    }

    private void sortAddons() {
        List<String> names = this.addons.stream().map(a -> a.getDescription().getName()).toList();
        Iterator<Addon> addonsIterator = this.addons.iterator();
        block0: while (addonsIterator.hasNext()) {
            Addon a2 = addonsIterator.next();
            for (String dependency : a2.getDescription().getDependencies()) {
                if (names.contains(dependency)) continue;
                this.plugin.logError(a2.getDescription().getName() + " has dependency on " + dependency + " that does not exist. Addon will not load!");
                addonsIterator.remove();
                continue block0;
            }
        }
        LinkedHashMap sortedAddons = new LinkedHashMap();
        this.addons.stream().filter(a -> a.getDescription().getDependencies().isEmpty() && a.getDescription().getSoftDependencies().isEmpty()).forEach(a -> sortedAddons.put(a.getDescription().getName(), a));
        List<Addon> remaining = this.addons.stream().filter(a -> !sortedAddons.containsKey(a.getDescription().getName())).toList();
        remaining.forEach(addon -> {
            ArrayList<String> dependencies = new ArrayList<String>(addon.getDescription().getDependencies());
            dependencies.addAll(addon.getDescription().getSoftDependencies());
            dependencies.removeIf(sortedAddons::containsKey);
            if (dependencies.stream().noneMatch(dependency -> addon.getDescription().getDependencies().contains(dependency))) {
                sortedAddons.put(addon.getDescription().getName(), addon);
            }
        });
        this.addons.clear();
        this.addons.addAll(sortedAddons.values());
    }

    public @Nullable ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        String w = worldName.replace("_nether", "").replace("_the_end", "").replace(BENTOBOX, "").toLowerCase(Locale.ENGLISH);
        if (this.worldNames.containsKey(w) && this.worldNames.get(w) != null) {
            return this.worldNames.get(w).getDefaultWorldGenerator(worldName, id);
        }
        return null;
    }

    public void registerListener(@NonNull Addon addon, @NonNull Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)BentoBox.getInstance());
        this.listeners.computeIfAbsent(addon, k -> new ArrayList()).add(listener);
    }

    private void disable(@NonNull Addon addon) {
        if (this.listeners.containsKey(addon)) {
            this.listeners.get(addon).forEach(HandlerList::unregisterAll);
            this.listeners.remove(addon);
        }
        this.plugin.getFlagsManager().unregister(addon);
        if (addon.isEnabled()) {
            this.plugin.log("Disabling " + addon.getDescription().getName() + "...");
            try {
                addon.onDisable();
            }
            catch (Exception e) {
                this.plugin.logError("Error occurred when disabling addon " + addon.getDescription().getName());
                this.plugin.logError("Report this to the addon's author(s)");
                addon.getDescription().getAuthors().forEach(this.plugin::logError);
                this.plugin.logStacktrace(e);
            }
            new AddonEvent().builder().addon(addon).reason(AddonEvent.Reason.DISABLE).build();
        }
        if (this.loaders.containsKey(addon)) {
            Set<String> unmodifiableSet = Collections.unmodifiableSet(this.loaders.get(addon).getClasses());
            for (String className : unmodifiableSet) {
                this.classes.remove(className);
            }
            addon.setState(Addon.State.DISABLED);
            this.loaders.remove(addon);
        }
        this.addons.remove(addon);
    }

    public Set<Class<? extends DataObject>> getDataObjects() {
        return this.classes.values().stream().filter(DataObject.class::isAssignableFrom).filter(c -> !ConfigObject.class.isAssignableFrom((Class<?>)c)).map(c -> c).collect(Collectors.toSet());
    }

    public void allLoaded() {
        this.getEnabledAddons().forEach(this::allLoaded);
    }

    private void allLoaded(@NonNull Addon addon) {
        try {
            addon.allLoaded();
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            this.handleAddonIncompatibility(addon, e);
            this.disable(addon);
        }
        catch (Exception e) {
            this.handleAddonError(addon, e);
            this.disable(addon);
        }
    }

    private record PladdonData(Addon addon, boolean success) {
    }
}

