/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.objects.IslandDeletion;
import world.bentobox.bentobox.util.DeleteIslandChunks;

public class IslandChunkDeletionManager
implements Runnable {
    private final boolean slowDeletion;
    private final BentoBox plugin;
    private final AtomicReference<DeleteIslandChunks> currentTask;
    private final Queue<IslandDeletion> queue;

    public IslandChunkDeletionManager(BentoBox plugin) {
        this.plugin = plugin;
        this.currentTask = new AtomicReference();
        this.queue = new LinkedList<IslandDeletion>();
        this.slowDeletion = plugin.getSettings().isSlowDeletion();
        if (this.slowDeletion) {
            Bukkit.getScheduler().runTaskTimer((Plugin)plugin, (Runnable)this, 0L, 20L);
        }
    }

    @Override
    public void run() {
        if (this.queue.isEmpty()) {
            return;
        }
        DeleteIslandChunks task = this.currentTask.get();
        if (task != null && !task.isCompleted()) {
            return;
        }
        IslandDeletion islandDeletion = this.queue.remove();
        this.currentTask.set(this.startDeleteTask(islandDeletion));
    }

    private DeleteIslandChunks startDeleteTask(IslandDeletion islandDeletion) {
        return new DeleteIslandChunks(this.plugin, islandDeletion);
    }

    public void add(IslandDeletion islandDeletion) {
        if (this.slowDeletion) {
            this.queue.add(islandDeletion);
        } else {
            this.startDeleteTask(islandDeletion);
        }
    }
}

