/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers.island;

import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BStats;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandCreateEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.island.IslandResetEvent;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.managers.island.DefaultNewIslandLocationStrategy;
import world.bentobox.bentobox.managers.island.NewIslandLocationStrategy;

public class NewIsland {
    private final BentoBox plugin = BentoBox.getInstance();
    private Island island;
    private final User user;
    private final IslandEvent.Reason reason;
    private final World world;
    private String name;
    private final boolean noPaste;
    private final GameModeAddon addon;
    private NewIslandLocationStrategy locationStrategy;

    public NewIsland(Builder builder) throws IOException {
        IslandBaseEvent event;
        this.user = builder.user2;
        this.reason = builder.reason2;
        this.world = builder.world2;
        this.name = builder.name2;
        this.noPaste = builder.noPaste2;
        this.addon = builder.addon2;
        this.locationStrategy = builder.locationStrategy2;
        if (this.locationStrategy == null) {
            this.locationStrategy = new DefaultNewIslandLocationStrategy();
        }
        if ((event = IslandEvent.builder().involvedPlayer(this.user.getUniqueId()).reason(IslandEvent.Reason.PRECREATE).build()).getNewEvent().map(IslandBaseEvent::isCancelled).orElse(event.isCancelled()).booleanValue()) {
            return;
        }
        this.newIsland(builder.oldIsland2);
    }

    public Island getIsland() {
        return this.island;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void newIsland(Island oldIsland) throws IOException {
        Location next = this.checkReservedIsland();
        if (next == null) {
            next = this.makeNextIsland();
        }
        this.cleanUpUser(next);
        IslandBaseEvent event = IslandEvent.builder().involvedPlayer(this.user.getUniqueId()).reason(this.reason).island(this.island).location(this.island.getCenter()).blueprintBundle(this.plugin.getBlueprintsManager().getBlueprintBundles(this.addon).get(this.name)).oldIsland(oldIsland).build();
        if (event.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(event.isCancelled()).booleanValue()) {
            return;
        }
        event = event.getNewEvent().orElse(event);
        switch (this.reason) {
            case CREATE: {
                this.name = ((IslandCreateEvent)event).getBlueprintBundle().getUniqueId();
                break;
            }
            case RESET: {
                this.name = ((IslandResetEvent)event).getBlueprintBundle().getUniqueId();
                break;
            }
        }
        this.plugin.getIslands().setPrimaryIsland(this.user.getUniqueId(), this.island);
        if (this.noPaste) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.postCreationTask(oldIsland));
        } else {
            boolean useNMS = this.user.isOfflinePlayer() || !this.user.getWorld().equals((Object)this.island.getWorld()) || this.user.getLocation().distance(this.island.getCenter()) >= (double)Bukkit.getViewDistance() * 16.0;
            this.plugin.getBlueprintsManager().paste(this.addon, this.island, this.name, () -> this.postCreationTask(oldIsland), useNMS);
        }
        this.island.setFlagsDefaults();
        this.plugin.getMetrics().ifPresent(BStats::increaseIslandsCreatedCount);
        this.island.log(new LogEntry.Builder(LogEntry.LogType.JOINED).data(this.user.getUniqueId().toString(), "owner").build());
        IslandsManager.updateIsland(this.island);
    }

    private void postCreationTask(Island oldIsland) {
        if (this.island.getSpawnPoint(World.Environment.NORMAL) != null) {
            this.plugin.getIslands().setHomeLocation(this.user, this.island.getSpawnPoint(World.Environment.NORMAL));
        }
        if (this.user.isOnline()) {
            if (this.reason.equals((Object)IslandEvent.Reason.RESET) || this.reason.equals((Object)IslandEvent.Reason.CREATE) && this.plugin.getIWM().isTeleportPlayerToIslandUponIslandCreation(this.world)) {
                this.user.getPlayer().setVelocity(new Vector(0, 0, 0));
                this.user.getPlayer().setFallDistance(0.0f);
                this.plugin.getIslands().homeTeleportAsync(this.world, this.user.getPlayer(), true).thenRun(() -> this.tidyUp(oldIsland));
                return;
            }
            this.user.sendMessage("commands.island.create.you-can-teleport-to-your-island", new String[0]);
        } else {
            User.removePlayer(this.user.getPlayer());
        }
        this.tidyUp(oldIsland);
    }

    private void cleanUpUser(Location loc) {
        if (this.plugin.getIWM().isDeathsResetOnNewIsland(this.world)) {
            this.plugin.getPlayers().setDeaths(this.world, this.user.getUniqueId(), 0);
        }
        this.island.setProtectionRange(this.user.getPermissionValue(this.plugin.getIWM().getAddon(this.island.getWorld()).map(Addon::getPermissionPrefix).orElse("") + "island.range", this.island.getProtectionRange()));
    }

    private Location makeNextIsland() throws IOException {
        Location next = this.locationStrategy.getNextLocation(this.world, this.user);
        if (next == null) {
            this.plugin.logError("Failed to make island - no unoccupied spot found.");
            this.plugin.logError("If the world was imported, try multiple times until all unowned islands are known.");
            throw new IOException("commands.island.create.cannot-create-island");
        }
        this.island = this.plugin.getIslands().createIsland(next, this.user.getUniqueId());
        if (this.island == null) {
            this.plugin.logError("Failed to make island! Island could not be added to the grid.");
            throw new IOException("commands.island.create.unable-create-island");
        }
        return next;
    }

    private Location checkReservedIsland() {
        if (this.plugin.getIslands().hasIsland(this.world, this.user)) {
            this.island = this.plugin.getIslands().getIsland(this.world, this.user);
            if (this.island != null && this.island.isReserved()) {
                Location l = this.island.getCenter();
                this.island.setReserved(false);
                return l;
            }
        }
        return null;
    }

    private void tidyUp(Island oldIsland) {
        if (oldIsland != null) {
            this.plugin.getIslands().deleteIsland(oldIsland, true, this.user.getUniqueId());
        }
        IslandEvent.builder().involvedPlayer(this.user.getUniqueId()).reason(this.reason == IslandEvent.Reason.RESET ? IslandEvent.Reason.RESETTED : IslandEvent.Reason.CREATED).island(this.island).location(this.island.getCenter()).oldIsland(oldIsland).build();
    }

    public static class Builder {
        private Island oldIsland2;
        private User user2;
        private IslandEvent.Reason reason2;
        private World world2;
        private String name2 = "default";
        private boolean noPaste2;
        private GameModeAddon addon2;
        private NewIslandLocationStrategy locationStrategy2;

        public Builder oldIsland(Island oldIsland) {
            this.oldIsland2 = oldIsland;
            this.world2 = oldIsland.getWorld();
            return this;
        }

        public Builder player(User player) {
            this.user2 = player;
            return this;
        }

        public Builder reason(IslandEvent.Reason reason) {
            if (!reason.equals((Object)IslandEvent.Reason.CREATE) && !reason.equals((Object)IslandEvent.Reason.RESET)) {
                throw new IllegalArgumentException("Reason must be CREATE or RESET.");
            }
            this.reason2 = reason;
            return this;
        }

        public Builder addon(GameModeAddon addon) {
            this.addon2 = addon;
            this.world2 = addon.getOverWorld();
            return this;
        }

        public Builder noPaste() {
            this.noPaste2 = true;
            return this;
        }

        public Builder name(String name) {
            this.name2 = name;
            return this;
        }

        public Builder locationStrategy(NewIslandLocationStrategy strategy) {
            this.locationStrategy2 = strategy;
            return this;
        }

        public Island build() throws IOException {
            if (this.user2 != null) {
                NewIsland newIsland = new NewIsland(this);
                return newIsland.getIsland();
            }
            throw new IOException("Insufficient parameters. Must have a user!");
        }
    }
}

