/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels;

import java.util.List;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.web.catalog.CatalogEntry;

public class CatalogPanel {
    private static final String LOCALE_REF = "catalog.panel.";
    private static final int[] PANES = new int[]{0, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};

    private CatalogPanel() {
    }

    public static void openPanel(@NonNull User user, @NonNull View view) {
        List<CatalogEntry> catalog;
        BentoBox plugin = BentoBox.getInstance();
        PanelBuilder builder = new PanelBuilder().name(user.getTranslation(LOCALE_REF + view.name() + ".title", new String[0])).size(45);
        for (int i : PANES) {
            builder.item(i, new PanelItemBuilder().icon(plugin.getSettings().getPanelFillerMaterial()).name(" ").build());
        }
        PanelItemBuilder gamemodesButton = new PanelItemBuilder().icon(Material.COMMAND_BLOCK).name(user.getTranslation("catalog.panel.views.gamemodes.name", new String[0])).description(user.getTranslation("catalog.panel.views.gamemodes.description", new String[0]));
        PanelItemBuilder addonsButton = new PanelItemBuilder().icon(Material.BOOK).name(user.getTranslation("catalog.panel.views.addons.name", new String[0])).description(user.getTranslation("catalog.panel.views.addons.description", new String[0]));
        if (view == View.GAMEMODES) {
            catalog = plugin.getWebManager().getGamemodesCatalog();
            gamemodesButton.glow(true);
            addonsButton.clickHandler((panel, user1, clickType, slot) -> {
                CatalogPanel.openPanel(user, View.ADDONS);
                return true;
            });
        } else {
            catalog = plugin.getWebManager().getAddonsCatalog();
            addonsButton.glow(true);
            gamemodesButton.clickHandler((panel, user1, clickType, slot) -> {
                CatalogPanel.openPanel(user, View.GAMEMODES);
                return true;
            });
        }
        builder.item(1, gamemodesButton.build());
        builder.item(2, addonsButton.build());
        if (catalog.isEmpty()) {
            CatalogPanel.looksEmpty(builder, user);
        } else {
            for (CatalogEntry addon : catalog) {
                String install;
                PanelItemBuilder itemBuilder = new PanelItemBuilder();
                String name = String.valueOf(NamedTextColor.WHITE) + addon.getName();
                if (addon.getTag() != null) {
                    name = name + " " + String.valueOf(NamedTextColor.AQUA) + String.valueOf(TextDecoration.BOLD) + user.getTranslation("catalog.tags." + addon.getTag(), new String[0]);
                }
                itemBuilder.icon(addon.getIcon()).name(name);
                if (plugin.getAddonsManager().getAddonByName(addon.getName()).isPresent()) {
                    itemBuilder.glow(true);
                    install = user.getTranslation("catalog.panel.icon.already-installed", new String[0]);
                } else {
                    install = user.getTranslation("catalog.panel.icon.install-now", new String[0]);
                }
                itemBuilder.description(user.getTranslation("catalog.panel.icon.description-template", "[topic]", StringUtils.capitalize((String)user.getTranslation("catalog.topics." + addon.getTopic(), new String[0])), "[install]", install, "[description]", addon.getDescription()));
                itemBuilder.clickHandler((panel, user1, clickType, slot) -> {
                    user1.sendRawMessage(String.valueOf(NamedTextColor.GRAY) + String.valueOf(TextDecoration.ITALIC) + "https://github.com/" + addon.getRepository() + "/releases");
                    return true;
                });
                builder.item(addon.getSlot(), itemBuilder.build());
            }
        }
        builder.build().open(user);
    }

    private static void looksEmpty(@NonNull PanelBuilder builder, @NonNull User user) {
        PanelItem emptyHere = new PanelItemBuilder().icon(Material.STRUCTURE_VOID).name(user.getTranslation("catalog.panel.empty-here.name", new String[0])).description(user.getTranslation("catalog.panel.empty-here.description", new String[0])).build();
        builder.item(22, emptyHere);
    }

    public static enum View {
        GAMEMODES,
        ADDONS;

    }
}

