/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Bat;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Flying;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.nms.AbstractMetaData;
import world.bentobox.bentobox.nms.PasteHandler;
import world.bentobox.bentobox.nms.WorldRegenerator;
import world.bentobox.bentobox.nms.fallback.GetMetaData;
import world.bentobox.bentobox.nms.fallback.PasteHandlerImpl;
import world.bentobox.bentobox.nms.fallback.WorldRegeneratorImpl;
import world.bentobox.bentobox.util.Pair;

public class Util {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})");
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";
    private static String serverVersion = null;
    private static BentoBox plugin = BentoBox.getInstance();
    private static PasteHandler pasteHandler = null;
    private static WorldRegenerator regenerator = null;
    private static AbstractMetaData metaData;

    private Util() {
    }

    public static void setPlugin(BentoBox p) {
        plugin = p;
    }

    public static String getServerVersion() {
        if (serverVersion == null) {
            String serverPackageName = Bukkit.getServer().getClass().getPackage().getName();
            serverVersion = serverPackageName.substring(serverPackageName.lastIndexOf(46) + 1);
        }
        return serverVersion;
    }

    public static Location getClosestIsland(Location location) {
        int dist = plugin.getIWM().getIslandDistance(location.getWorld()) * 2;
        long x = Math.round((double)location.getBlockX() / (double)dist) * (long)dist + (long)plugin.getIWM().getIslandXOffset(location.getWorld());
        long z = Math.round((double)location.getBlockZ() / (double)dist) * (long)dist + (long)plugin.getIWM().getIslandZOffset(location.getWorld());
        int y = plugin.getIWM().getIslandHeight(location.getWorld());
        return new Location(location.getWorld(), (double)x, (double)y, (double)z);
    }

    public static Location getLocationString(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        String[] parts = s.split(":");
        if (parts.length == 6) {
            World w = Bukkit.getWorld((String)parts[0]);
            if (w == null) {
                return null;
            }
            int x = (int)Double.parseDouble(parts[1]);
            int y = (int)Double.parseDouble(parts[2]);
            int z = (int)Double.parseDouble(parts[3]);
            float yaw = Float.intBitsToFloat(Integer.parseInt(parts[4]));
            float pitch = Float.intBitsToFloat(Integer.parseInt(parts[5]));
            return new Location(w, (double)x + 0.5, (double)y, (double)z + 0.5, yaw, pitch);
        }
        return null;
    }

    public static String getStringLocation(Location l) {
        if (l == null || l.getWorld() == null) {
            return "";
        }
        return l.getWorld().getName() + ":" + l.getBlockX() + ":" + l.getBlockY() + ":" + l.getBlockZ() + ":" + Float.floatToIntBits(l.getYaw()) + ":" + Float.floatToIntBits(l.getPitch());
    }

    public static String prettifyText(String ugly) {
        StringBuilder fin = new StringBuilder();
        if ((ugly = ugly.toLowerCase(Locale.ENGLISH)).contains("_")) {
            String[] splt = ugly.split("_");
            int i = 0;
            for (String s : splt) {
                fin.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1));
                if (++i >= splt.length) continue;
                fin.append(" ");
            }
        } else {
            fin.append(Character.toUpperCase(ugly.charAt(0))).append(ugly.substring(1));
        }
        return fin.toString();
    }

    public static List<String> getOnlinePlayerList(User user) {
        if (user == null || !user.isPlayer()) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return Bukkit.getOnlinePlayers().stream().filter(p -> user.getPlayer().canSee(p)).map(Player::getName).toList();
    }

    public static List<String> tabLimit(List<String> list, String start) {
        ArrayList<String> returned = new ArrayList<String>();
        for (String s : list) {
            if (s == null || !s.toLowerCase(Locale.ENGLISH).startsWith(start.toLowerCase(Locale.ENGLISH))) continue;
            returned.add(s);
        }
        return returned;
    }

    public static String xyz(Vector location) {
        return location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    public static boolean sameWorld(World world, World world2) {
        return Util.stripName(world).equals(Util.stripName(world2));
    }

    private static String stripName(World world) {
        if (world.getName().endsWith(NETHER)) {
            return world.getName().substring(0, world.getName().length() - NETHER.length());
        }
        if (world.getName().endsWith(THE_END)) {
            return world.getName().substring(0, world.getName().length() - THE_END.length());
        }
        return world.getName();
    }

    public static @Nullable World getWorld(@Nullable World world) {
        if (world == null) {
            return null;
        }
        return world.getEnvironment().equals((Object)World.Environment.NORMAL) ? world : Bukkit.getWorld((String)world.getName().replace(NETHER, "").replace(THE_END, ""));
    }

    public static List<String> listJarFiles(JarFile jar, String folderPath, String suffix) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!path.startsWith(folderPath) || !entry.getName().endsWith(suffix)) continue;
            result.add(entry.getName());
        }
        return result;
    }

    public static float blockFaceToFloat(BlockFace face) {
        return switch (face) {
            case BlockFace.EAST -> 90.0f;
            case BlockFace.EAST_NORTH_EAST -> 67.5f;
            case BlockFace.NORTH_EAST -> 45.0f;
            case BlockFace.NORTH_NORTH_EAST -> 22.5f;
            case BlockFace.NORTH_NORTH_WEST -> 337.5f;
            case BlockFace.NORTH_WEST -> 315.0f;
            case BlockFace.SOUTH -> 180.0f;
            case BlockFace.SOUTH_EAST -> 135.0f;
            case BlockFace.SOUTH_SOUTH_EAST -> 157.5f;
            case BlockFace.SOUTH_SOUTH_WEST -> 202.5f;
            case BlockFace.SOUTH_WEST -> 225.0f;
            case BlockFace.WEST -> 270.0f;
            case BlockFace.WEST_NORTH_WEST -> 292.5f;
            case BlockFace.WEST_SOUTH_WEST -> 247.5f;
            default -> 0.0f;
        };
    }

    public static @Nullable Date parseGitHubDate(@NonNull String gitHubDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(gitHubDate.replace('T', ' ').replace("Z", ""));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isHostileEntity(Entity entity) {
        return entity instanceof Monster || entity instanceof Flying || entity instanceof Slime || entity instanceof Shulker || entity instanceof EnderDragon || entity instanceof PufferFish;
    }

    public static boolean isPassiveEntity(Entity entity) {
        return entity instanceof Animals || entity instanceof IronGolem || entity instanceof Snowman || entity instanceof WaterMob && !(entity instanceof PufferFish) || entity instanceof Bat || entity instanceof Allay;
    }

    public static boolean isTamableEntity(Entity entity) {
        return entity instanceof Tameable && ((Tameable)entity).isTamed();
    }

    public static @NonNull CompletableFuture<Boolean> teleportAsync(@Nonnull Entity entity, @Nonnull Location location) {
        return Util.teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public static @NonNull CompletableFuture<Boolean> teleportAsync(@Nonnull Entity entity, @Nonnull Location location, PlayerTeleportEvent.TeleportCause cause) {
        try {
            Method method = Entity.class.getMethod("teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class);
            if (method != null) {
                return (CompletableFuture)method.invoke((Object)entity, location, cause);
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            plugin.logStacktrace(e);
        }
        entity.teleport(location, cause);
        return CompletableFuture.completedFuture(true);
    }

    public static @NonNull CompletableFuture<Chunk> getChunkAtAsync(@NonNull Location loc) {
        return Util.getChunkAtAsync(Objects.requireNonNull(loc.getWorld()), loc.getBlockX() >> 4, loc.getBlockZ() >> 4, true);
    }

    public static @NonNull CompletableFuture<Chunk> getChunkAtAsync(@NonNull Location loc, boolean gen) {
        return Util.getChunkAtAsync(Objects.requireNonNull(loc.getWorld()), loc.getBlockX() >> 4, loc.getBlockZ() >> 4, gen);
    }

    public static @NonNull CompletableFuture<Chunk> getChunkAtAsync(@Nonnull World world, int x, int z) {
        return Util.getChunkAtAsync(world, x, z, true);
    }

    public static @NonNull CompletableFuture<Chunk> getChunkAtAsync(@Nonnull World world, int x, int z, boolean gen) {
        try {
            Method method = World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            if (method != null) {
                return (CompletableFuture)method.invoke((Object)world, x, z, gen);
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(world.getChunkAt(x, z, gen));
    }

    public static boolean isChunkGenerated(@NonNull Location loc) {
        return Util.isChunkGenerated(Objects.requireNonNull(loc.getWorld()), loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    public static boolean isChunkGenerated(@Nonnull World world, int x, int z) {
        return world.isChunkGenerated(x, z);
    }

    public static boolean isVersionCompatible(String version, String requiredVersion) {
        String[] versionParts = version.replace("-SNAPSHOT", "").split("\\.");
        String[] requiredVersionParts = requiredVersion.replace("-SNAPSHOT", "").split("\\.");
        for (int i = 0; i < Math.max(versionParts.length, requiredVersionParts.length); ++i) {
            int rPart;
            int vPart = i < versionParts.length ? Integer.parseInt(versionParts[i]) : 0;
            int n = rPart = i < requiredVersionParts.length ? Integer.parseInt(requiredVersionParts[i]) : 0;
            if (vPart > rPart) {
                return true;
            }
            if (vPart >= rPart) continue;
            return false;
        }
        boolean isVersionSnapshot = version.contains("-SNAPSHOT");
        boolean isRequiredSnapshot = requiredVersion.contains("-SNAPSHOT");
        return isRequiredSnapshot || !isVersionSnapshot;
    }

    public static boolean isPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static @NonNull String translateColorCodes(@NonNull String textToColor) {
        Matcher matcher = HEX_PATTERN.matcher(textToColor);
        StringBuilder buffer = new StringBuilder(textToColor.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            if (group.length() == 6) {
                matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
                continue;
            }
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(2));
        }
        return Util.stripSpaceAfterColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString()));
    }

    public static @NonNull String stripSpaceAfterColorCodes(@NonNull String textToStrip) {
        if (textToStrip == null) {
            return "";
        }
        textToStrip = textToStrip.replaceAll("(\u00a7.)[\\s]", "$1");
        return textToStrip;
    }

    public static boolean isInteger(@NonNull String nbr, boolean parse) {
        int length = nbr.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (nbr.charAt(0) == '-' || nbr.charAt(0) == '+') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        boolean trailingDot = false;
        while (i < length) {
            char c = nbr.charAt(i);
            if (trailingDot && c != '0') {
                return false;
            }
            if (c == '.') {
                if (i == length - 1) {
                    return true;
                }
                trailingDot = true;
            } else if (!(trailingDot || c >= '0' && c <= '9')) {
                return false;
            }
            ++i;
        }
        if (parse) {
            try {
                Integer.parseInt(nbr);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static @Nullable UUID getUUID(@NonNull String nameOrUUID) {
        UUID targetUUID = plugin.getPlayers().getUUID(nameOrUUID);
        if (targetUUID != null) {
            return targetUUID;
        }
        try {
            return UUID.fromString(nameOrUUID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void runCommands(User user, @NonNull List<String> commands, String commandType) {
        Util.runCommands(user, user.getName(), commands, commandType);
    }

    public static void runCommands(User user, String ownerName, @NonNull List<String> commands, String commandType) {
        commands.forEach(command -> {
            command = command.replace("[player]", user.getName());
            if ((command = command.replace("[owner]", ownerName)).startsWith("[SUDO]")) {
                if (!user.isOnline() || !user.performCommand(command.substring(6))) {
                    plugin.logError("Could not execute " + commandType + " command for " + user.getName() + ": " + command.substring(6));
                }
            } else if (!Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command)) {
                plugin.logError("Could not execute " + commandType + " command as console: " + command);
            }
        });
    }

    public static void resetHealth(Player player) {
        try {
            double maxHealth = player.getAttribute(Attribute.MAX_HEALTH).getBaseValue();
            player.setHealth(maxHealth);
        }
        catch (Exception e) {
            player.setHealth(20.0);
        }
    }

    public static void setRegenerator(WorldRegenerator regenerator) {
        Util.regenerator = regenerator;
    }

    private static Pair<String, String> getPrefix() {
        String bukkitVersion = "v" + Bukkit.getBukkitVersion().replace('.', '_').replace('-', '_');
        String pluginPackageName = ((Object)((Object)plugin)).getClass().getPackage().getName();
        return new Pair<CallSite, CallSite>((CallSite)((Object)(pluginPackageName + ".nms." + bukkitVersion)), (CallSite)((Object)bukkitVersion));
    }

    private static <T> T getNMSHandler(Class<T> handlerClass, String implName, Supplier<T> fallbackSupplier, T existingHandler, String logPrefix) {
        T handler;
        if (existingHandler != null) {
            return existingHandler;
        }
        try {
            Class<?> clazz = Class.forName(Util.getPrefix().x() + "." + implName);
            if (!handlerClass.isAssignableFrom(clazz)) {
                throw new IllegalStateException("Class " + clazz.getName() + " does not implement " + handlerClass.getSimpleName());
            }
            handler = handlerClass.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            plugin.logWarning("No " + logPrefix + " found for " + Util.getPrefix().z() + ", falling back to Bukkit API.");
            handler = fallbackSupplier.get();
        }
        return handler;
    }

    public static AbstractMetaData getMetaData() {
        if (metaData == null) {
            metaData = Util.getNMSHandler(AbstractMetaData.class, "GetMetaData", () -> new GetMetaData(), metaData, "GetMetaData");
        }
        return metaData;
    }

    public static WorldRegenerator getRegenerator() {
        if (regenerator == null) {
            regenerator = Util.getNMSHandler(WorldRegenerator.class, "WorldRegeneratorImpl", () -> new WorldRegeneratorImpl(), regenerator, "Regenerator");
        }
        return regenerator;
    }

    public static PasteHandler getPasteHandler() {
        if (pasteHandler == null) {
            BentoBox.getInstance().log("Optimizing for " + Util.getPrefix().z());
            pasteHandler = Util.getNMSHandler(PasteHandler.class, "PasteHandlerImpl", () -> new PasteHandlerImpl(), pasteHandler, "PasteHandler");
        }
        return pasteHandler;
    }

    public static int broadcast(String localeKey, String ... variables) {
        int count = 0;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("bukkit.broadcast.user")) continue;
            User.getInstance(p).sendMessage(localeKey, variables);
            ++count;
        }
        return count;
    }

    public static String sanitizeInput(String input) {
        return Util.stripColor(Util.translateColorCodes(input.replaceAll("[\\\\/:*?\"<>| ]", "_"))).toLowerCase();
    }

    public static <T extends Enum<T>> T findFirstMatchingEnum(Class<T> enumClass, String ... values) {
        if (enumClass == null || values == null) {
            return null;
        }
        for (String value : values) {
            Optional enumConstant = Enums.getIfPresent(enumClass, (String)value.toUpperCase());
            if (!enumConstant.isPresent()) continue;
            return (T)((Enum)enumConstant.get());
        }
        return null;
    }

    public static boolean inTest() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(e -> e.getClassName().endsWith("Test"));
    }

    public static String stripColor(String input) {
        return input.replaceAll("(?i)\u00a7[0-9A-FK-ORX]", "");
    }
}

