/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util.heads;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Base64;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.util.ExpiringMap;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.heads.HeadCache;
import world.bentobox.bentobox.util.heads.HeadRequester;

public class HeadGetter {
    private static final ExpiringMap<String, HeadCache> cachedHeads = new ExpiringMap(1L, TimeUnit.HOURS);
    private static final Queue<Pair<String, PanelItem>> names = new LinkedBlockingQueue<Pair<String, PanelItem>>();
    private static final ExpiringMap<String, Set<HeadRequester>> headRequesters = new ExpiringMap(10L, TimeUnit.SECONDS);
    private static final String TEXTURES = "textures";
    private static final String NAME = "name";
    private final BentoBox plugin;

    public HeadGetter(BentoBox plugin) {
        this.plugin = plugin;
        this.runPlayerHeadGetter();
    }

    public static void shutdown() {
        cachedHeads.shutdown();
        headRequesters.shutdown();
    }

    public static void getHead(PanelItem panelItem, HeadRequester requester) {
        HeadCache cache = cachedHeads.get(panelItem.getPlayerHeadName());
        long cacheTimeout = BentoBox.getInstance().getSettings().getPlayerHeadCacheTime() * 60L * 1000L;
        if (cache != null && (cache.getTimestamp() == 0L || cacheTimeout == 0L || System.currentTimeMillis() - cache.getTimestamp() <= cacheTimeout)) {
            panelItem.setHead(cachedHeads.get(panelItem.getPlayerHeadName()).getPlayerHead());
            requester.setHead(panelItem);
        } else {
            headRequesters.computeIfAbsent(panelItem.getPlayerHeadName(), k -> new HashSet()).add(requester);
            names.add(new Pair<String, PanelItem>(panelItem.getPlayerHeadName(), panelItem));
        }
    }

    public static void addToCache(HeadCache cache) {
        cachedHeads.put(cache.getUserName(), cache);
    }

    private void runPlayerHeadGetter() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            Queue<Pair<String, PanelItem>> queue = names;
            synchronized (queue) {
                for (int counter = 0; !names.isEmpty() && counter < this.plugin.getSettings().getHeadsPerCall(); ++counter) {
                    Pair<String, PanelItem> elementEntry = names.poll();
                    String userName = elementEntry.getKey();
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        HeadCache cache;
                        UUID userId = cachedHeads.containsKey(userName) ? cachedHeads.get(userName).getUserId() : (Bukkit.getServer().getOnlineMode() ? this.plugin.getPlayers().getUUID(userName) : null);
                        if (this.plugin.getSettings().isUseCacheServer()) {
                            Pair<UUID, String> playerSkin = HeadGetter.getTextureFromName(userName, userId);
                            cache = new HeadCache(userName, playerSkin.getKey(), HeadGetter.createProfile(userName, playerSkin.getKey(), playerSkin.getValue()));
                        } else {
                            if (userId == null) {
                                userId = HeadGetter.getUserIdFromName(userName);
                            }
                            cache = new HeadCache(userName, userId, HeadGetter.createProfile(userName, userId, HeadGetter.getTextureFromUUID(userId)));
                        }
                        cachedHeads.put(userName, cache);
                        if (cache.playerProfile != null && headRequesters.containsKey(userName)) {
                            for (HeadRequester req : headRequesters.get(userName)) {
                                ((PanelItem)elementEntry.getValue()).setHead(cache.getPlayerHead());
                                if (this.plugin.isShutdown()) continue;
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> req.setHead((PanelItem)elementEntry.getValue()));
                            }
                        }
                    });
                }
            }
        }, 0L, this.plugin.getSettings().getTicksBetweenCalls());
    }

    private static UUID getUserIdFromName(String name) {
        UUID userId;
        try {
            Gson gsonReader = new Gson();
            JsonObject jsonObject = (JsonObject)gsonReader.fromJson(HeadGetter.getURLContent("https://api.mojang.com/users/profiles/minecraft/" + name), JsonObject.class);
            String userIdString = jsonObject.get("id").toString().replace("\"", "").replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
            userId = UUID.fromString(userIdString);
        }
        catch (Exception ignored) {
            userId = UUID.randomUUID();
        }
        return userId;
    }

    private static @Nullable String getTextureFromUUID(UUID userId) {
        try {
            Gson gsonReader = new Gson();
            JsonObject jsonObject = (JsonObject)gsonReader.fromJson(HeadGetter.getURLContent("https://sessionserver.mojang.com/session/minecraft/profile/" + userId.toString()), JsonObject.class);
            String decodedTexture = "";
            for (JsonElement element : jsonObject.getAsJsonArray("properties")) {
                JsonObject object = element.getAsJsonObject();
                if (!object.has(NAME) || !object.get(NAME).getAsString().equals(TEXTURES)) continue;
                decodedTexture = object.get("value").getAsString();
                break;
            }
            return decodedTexture;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static @NonNull Pair<UUID, String> getTextureFromName(String userName, @Nullable UUID userId) {
        try {
            Gson gsonReader = new Gson();
            JsonObject jsonObject = (JsonObject)gsonReader.fromJson(HeadGetter.getURLContent("https://mc-heads.net/minecraft/profile/" + (userId == null ? userName : userId.toString())), JsonObject.class);
            String decodedTexture = "";
            String userIdString = jsonObject.get("id").toString().replace("\"", "").replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
            for (JsonElement element : jsonObject.getAsJsonArray("properties")) {
                JsonObject object = element.getAsJsonObject();
                if (!object.has(NAME) || !object.get(NAME).getAsString().equals(TEXTURES)) continue;
                decodedTexture = object.get("value").getAsString();
                break;
            }
            return new Pair<UUID, String>(UUID.fromString(userIdString), decodedTexture);
        }
        catch (Exception exception) {
            return new Pair<UUID, Object>(userId, null);
        }
    }

    private static String getURLContent(String requestedUrl) {
        String returnValue;
        try {
            URL url = new URL(requestedUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            returnValue = br.lines().collect(Collectors.joining());
            br.close();
        }
        catch (Exception e) {
            returnValue = "";
        }
        return returnValue;
    }

    private static URL getSkinURLFromBase64(String base64) {
        try {
            String decoded = new String(Base64.getDecoder().decode(base64));
            JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
            String url = json.getAsJsonObject(TEXTURES).getAsJsonObject("SKIN").get("url").getAsString();
            return new URI(url).toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PlayerProfile createProfile(@NonNull String userName, @NonNull UUID uuid, @Nullable String encodedBase64Texture) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)uuid, (String)userName);
        if (encodedBase64Texture != null && !encodedBase64Texture.isEmpty()) {
            URL skinURL = HeadGetter.getSkinURLFromBase64(encodedBase64Texture);
            profile.getTextures().setSkin(skinURL);
        }
        return profile;
    }
}

