/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util.teleport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Pair;
import world.bentobox.bentobox.util.Util;

public class SafeSpotTeleport {
    private static final int MAX_CHUNKS = 6;
    private static final long SPEED = 1L;
    private static final int MAX_RADIUS = 50;
    private final @NonNull Entity entity;
    private final @NonNull Location location;
    private final int homeNumber;
    private final BentoBox plugin;
    private final Runnable runnable;
    private final Runnable failRunnable;
    private final CompletableFuture<Boolean> result;
    private final String homeName;
    private final int maxHeight;
    private final World world;
    private final AtomicBoolean checking = new AtomicBoolean();
    private BukkitTask task;
    private boolean portal;
    private boolean cancelIfFail;
    private Location bestSpot;
    private Iterator<Pair<Integer, Integer>> chunksToScanIterator;
    private int checkedChunks = 0;

    SafeSpotTeleport(Builder builder) {
        this.plugin = builder.getPlugin();
        this.entity = Objects.requireNonNull(builder.getEntity());
        this.location = Objects.requireNonNull(builder.getLocation());
        this.portal = builder.isPortal();
        this.homeNumber = builder.getHomeNumber();
        this.homeName = builder.getHomeName();
        this.runnable = builder.getRunnable();
        this.failRunnable = builder.getFailRunnable();
        this.result = builder.getResult();
        this.world = Objects.requireNonNull(this.location.getWorld());
        this.maxHeight = this.world.getMaxHeight() - 20;
        this.cancelIfFail = builder.isCancelIfFail();
        Util.getChunkAtAsync(this.location).thenRun(() -> this.tryToGo(builder.getFailureMessage()));
    }

    void tryToGo(String failureMessage) {
        if (this.plugin.getIslands().isSafeLocation(this.location)) {
            if (this.portal) {
                this.bestSpot = this.location;
            } else {
                Util.teleportAsync(Objects.requireNonNull(this.entity), Objects.requireNonNull(this.location)).thenRun(() -> {
                    if (this.runnable != null) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, this.runnable);
                    }
                    this.result.complete(true);
                });
                return;
            }
        }
        this.chunksToScanIterator = this.getChunksToScan().iterator();
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.gatherChunks(failureMessage), 0L, 1L);
    }

    boolean gatherChunks(String failureMessage) {
        if (this.checking.get()) {
            return false;
        }
        this.checking.set(true);
        if (this.checkedChunks > 6 || !this.chunksToScanIterator.hasNext()) {
            this.tidyUp(this.entity, failureMessage);
            return false;
        }
        Pair<Integer, Integer> chunkPair = this.chunksToScanIterator.next();
        this.chunksToScanIterator.remove();
        ++this.checkedChunks;
        if (this.checkedChunks >= 6) {
            this.checking.set(false);
            return false;
        }
        ((CompletableFuture)Util.getChunkAtAsync(Objects.requireNonNull(this.world), chunkPair.x(), chunkPair.z()).thenApply(Chunk::getChunkSnapshot)).whenCompleteAsync((snapshot, e) -> {
            if (snapshot != null && this.scanChunk((ChunkSnapshot)snapshot)) {
                this.task.cancel();
            } else {
                this.checking.set(false);
            }
        });
        return true;
    }

    void tidyUp(Entity entity, String failureMessage) {
        this.task.cancel();
        if (this.portal && this.bestSpot != null) {
            this.teleportEntity(this.bestSpot);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!failureMessage.isEmpty()) {
                    User.getInstance((CommandSender)entity).notify(failureMessage, new String[0]);
                }
                if (!this.plugin.getIWM().inWorld(entity.getLocation())) {
                    player.performCommand("spawn");
                } else if (!this.cancelIfFail) {
                    if (this.world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                        this.makeAndTeleport(Material.NETHERRACK);
                    } else if (this.world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                        this.makeAndTeleport(Material.END_STONE);
                    } else {
                        this.makeAndTeleport(Material.COBBLESTONE);
                    }
                }
                if (this.failRunnable != null) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, this.failRunnable);
                }
                this.result.complete(false);
            });
        } else {
            if (this.failRunnable != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, this.failRunnable);
            }
            this.result.complete(false);
        }
    }

    void makeAndTeleport(Material m) {
        this.location.getBlock().getRelative(BlockFace.DOWN).setType(m, false);
        this.location.getBlock().setType(Material.AIR, false);
        this.location.getBlock().getRelative(BlockFace.UP).setType(Material.AIR, false);
        this.location.getBlock().getRelative(BlockFace.UP).getRelative(BlockFace.UP).setType(m, false);
        Util.teleportAsync(Objects.requireNonNull(this.entity), Objects.requireNonNull(this.location.clone().add(new Vector(0.5, 0.0, 0.5)))).thenRun(() -> {
            if (this.runnable != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, this.runnable);
            }
            this.result.complete(true);
        });
    }

    List<Pair<Integer, Integer>> getChunksToScan() {
        ArrayList<Pair<Integer, Integer>> chunksToScan = new ArrayList<Pair<Integer, Integer>>();
        int maxRadius = this.plugin.getIslands().getIslandAt(this.location).map(Island::getProtectionRange).orElseGet(() -> this.plugin.getIWM().getIslandProtectionRange(this.world));
        maxRadius = Math.min(50, maxRadius);
        int x = this.location.getBlockX();
        int z = this.location.getBlockZ();
        int radius = 0;
        do {
            for (int i = x - radius; i <= x + radius; i += 16) {
                for (int j = z - radius; j <= z + radius; j += 16) {
                    this.addChunk(chunksToScan, new Pair<Integer, Integer>(i, j), new Pair<Integer, Integer>(i >> 4, j >> 4));
                }
            }
        } while (++radius < maxRadius);
        return chunksToScan;
    }

    private void addChunk(List<Pair<Integer, Integer>> chunksToScan, Pair<Integer, Integer> blockCoord, Pair<Integer, Integer> chunkCoord) {
        if (!chunksToScan.contains(chunkCoord) && this.plugin.getIslands().getIslandAt(this.location).map(is -> is.inIslandSpace(blockCoord)).orElse(true).booleanValue()) {
            chunksToScan.add(chunkCoord);
        }
    }

    boolean scanChunk(ChunkSnapshot chunk) {
        int startY = this.location.getBlockY();
        int minY = this.world.getMinHeight();
        int maxY = 60;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (minY <= startY && this.checkBlock(chunk, x, startY, z)) {
                    return true;
                }
                maxY = Math.max(chunk.getHighestBlockYAt(x, z), maxY);
            }
        }
        maxY = Math.min(maxY, this.maxHeight);
        int upperY = startY + 1;
        int lowerY = startY - 1;
        boolean checkUpper = upperY <= maxY;
        boolean checkLower = lowerY >= minY;
        for (int limitRange = this.plugin.getSettings().getSafeSpotSearchVerticalRange(); limitRange > 0 && (checkUpper || checkLower); --limitRange) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (checkUpper && this.checkBlock(chunk, x, upperY, z)) {
                        return true;
                    }
                    if (!checkLower || !this.checkBlock(chunk, x, lowerY, z)) continue;
                    return true;
                }
            }
            if (checkUpper && ++upperY > maxY) {
                checkUpper = false;
            }
            if (!checkLower || --lowerY >= minY) continue;
            checkLower = false;
        }
        return false;
    }

    void teleportEntity(@NonNull Location loc) {
        this.task.cancel();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!(this.portal || !(this.entity instanceof Player) || this.homeNumber <= 0 && this.homeName.isEmpty())) {
                this.plugin.getIslands().setHomeLocation(User.getInstance((CommandSender)this.entity), loc, this.homeName);
            }
            Util.teleportAsync(Objects.requireNonNull(this.entity), Objects.requireNonNull(loc)).thenRun(() -> {
                if (this.runnable != null) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, this.runnable);
                }
                this.result.complete(true);
            });
        });
    }

    boolean checkBlock(ChunkSnapshot chunk, int x, int y, int z) {
        Material type = chunk.getBlockType(x, y, z);
        Material space1 = chunk.getBlockType(x, Math.min(y + 1, this.maxHeight), z);
        Material space2 = chunk.getBlockType(x, Math.min(y + 2, this.maxHeight), z);
        if (space1.equals((Object)Material.NETHER_PORTAL) || space2.equals((Object)Material.NETHER_PORTAL)) {
            this.portal = false;
        }
        if (this.plugin.getIslands().checkIfSafe(this.world, type, space1, space2)) {
            return this.safe(chunk, x, y, z, this.world);
        }
        return false;
    }

    boolean safe(ChunkSnapshot chunk, int x, int y, int z, World world) {
        Vector newSpot = new Vector((double)((chunk.getX() << 4) + x) + 0.5, (double)y + 1.0, (double)((chunk.getZ() << 4) + z) + 0.5);
        if (this.portal) {
            if (this.bestSpot == null) {
                this.bestSpot = newSpot.toLocation(world);
            }
            return false;
        }
        this.teleportEntity(newSpot.toLocation(world));
        return true;
    }

    public static class Builder {
        private final BentoBox plugin;
        private final CompletableFuture<Boolean> result = new CompletableFuture();
        private Entity entity;
        private int homeNumber = 0;
        private String homeName = "";
        private boolean portal = false;
        private String failureMessage = "";
        private Location location;
        private Runnable runnable;
        private Runnable failRunnable;
        private boolean cancelIfFail;

        public Builder(BentoBox plugin) {
            this.plugin = plugin;
        }

        public Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public Builder island(Island island) {
            this.location = island.getProtectionCenter();
            return this;
        }

        public Builder homeName(String homeName) {
            this.homeName = homeName;
            return this;
        }

        public Builder portal() {
            this.portal = true;
            return this;
        }

        public Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public @Nullable CompletableFuture<Boolean> buildFuture() {
            this.build();
            return this.result;
        }

        public @Nullable SafeSpotTeleport build() {
            if (this.entity == null) {
                this.plugin.logError("Attempt to safe teleport a null entity!");
                this.result.complete(null);
                return null;
            }
            if (this.location == null) {
                this.plugin.logError("Attempt to safe teleport to a null location!");
                this.result.complete(null);
                return null;
            }
            if (this.location.getWorld() == null) {
                this.plugin.logError("Attempt to safe teleport to a null world!");
                this.result.complete(null);
                return null;
            }
            if (this.failureMessage.isEmpty() && this.entity instanceof Player) {
                this.failureMessage = "general.errors.no-safe-location-found";
            }
            return new SafeSpotTeleport(this);
        }

        public Builder cancelIfFail(boolean cancelIfFail) {
            this.cancelIfFail = cancelIfFail;
            return this;
        }

        public Builder thenRun(Runnable runnable) {
            this.runnable = runnable;
            return this;
        }

        public Builder ifFail(Runnable runnable) {
            this.failRunnable = runnable;
            return this;
        }

        public BentoBox getPlugin() {
            return this.plugin;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public int getHomeNumber() {
            return this.homeNumber;
        }

        public String getHomeName() {
            return this.homeName;
        }

        public boolean isPortal() {
            return this.portal;
        }

        public String getFailureMessage() {
            return this.failureMessage;
        }

        public Location getLocation() {
            return this.location;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public CompletableFuture<Boolean> getResult() {
            return this.result;
        }

        public Runnable getFailRunnable() {
            return this.failRunnable;
        }

        public boolean isCancelIfFail() {
            return this.cancelIfFail;
        }
    }
}

