/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.web.catalog;

import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import org.bukkit.Material;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CatalogEntry {
    private final int slot;
    private final @NonNull Material icon;
    private final @NonNull String name;
    private final @NonNull String description;
    private final @Nullable String topic;
    private final @Nullable String tag;
    private final @NonNull String repository;

    public CatalogEntry(@NonNull JsonObject object) {
        this.slot = object.get("slot").getAsInt();
        Material material = Material.getMaterial((String)object.get("icon").getAsString());
        this.icon = material != null ? material : Material.PAPER;
        this.name = object.get("name").getAsString();
        this.description = object.get("description").getAsString();
        this.repository = object.get("repository").getAsString();
        this.topic = object.get("topic").getAsString();
        this.tag = !(object.get("tag") instanceof JsonNull) ? object.get("tag").getAsString() : null;
    }

    public int getSlot() {
        return this.slot;
    }

    public @NonNull Material getIcon() {
        return this.icon;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public @Nullable String getTopic() {
        return this.topic;
    }

    public @Nullable String getTag() {
        return this.tag;
    }

    public @NonNull String getRepository() {
        return this.repository;
    }
}

