/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.addons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.AddonDescription;
import world.bentobox.bentobox.api.addons.request.AddonRequestHandler;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.managers.PlayersManager;
import world.bentobox.bentobox.multilib.MultiLib;
import world.bentobox.bentobox.util.Util;

public abstract class Addon {
    private static final String ADDON_CONFIG_FILENAME = "config.yml";
    private State state;
    private AddonDescription description;
    private FileConfiguration config;
    private File dataFolder;
    private File file;
    private final Map<String, AddonRequestHandler> requestHandlers = new HashMap<String, AddonRequestHandler>();

    protected Addon() {
        this.state = State.DISABLED;
        if (!Util.inTest()) {
            MultiLib.onString((Plugin)this.getPlugin(), "bentobox-config-update", v -> this.reloadConfig());
        }
    }

    public abstract void onEnable();

    public abstract void onDisable();

    public void onLoad() {
    }

    public void onReload() {
    }

    public BentoBox getPlugin() {
        return BentoBox.getInstance();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.config = this.loadYamlFile();
        }
        return this.config;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public AddonDescription getDescription() {
        return this.description;
    }

    public File getFile() {
        return this.file;
    }

    public Logger getLogger() {
        return this.getPlugin().getLogger();
    }

    public Server getServer() {
        return Bukkit.getServer();
    }

    public boolean isEnabled() {
        return this.state == State.ENABLED;
    }

    public State getState() {
        return this.state;
    }

    private FileConfiguration loadYamlFile() {
        File yamlFile = new File(this.dataFolder, ADDON_CONFIG_FILENAME);
        YamlConfiguration yamlConfig = null;
        if (yamlFile.exists()) {
            try {
                yamlConfig = new YamlConfiguration();
                yamlConfig.load(yamlFile);
            }
            catch (Exception e) {
                BentoBox.getInstance().logError("Could not load config.yml: " + e.getMessage());
            }
        }
        return yamlConfig;
    }

    public void registerListener(Listener listener) {
        BentoBox.getInstance().getAddonsManager().registerListener(this, listener);
    }

    public void saveConfig() {
        try {
            this.getConfig().save(new File(this.dataFolder, ADDON_CONFIG_FILENAME));
        }
        catch (IOException e) {
            BentoBox.getInstance().logError("Could not save config! " + this.getDescription().getName() + " " + e.getMessage());
        }
    }

    public void reloadConfig() {
        this.config = this.loadYamlFile();
    }

    public void saveDefaultConfig() {
        this.saveResource(ADDON_CONFIG_FILENAME, false);
        this.config = this.loadYamlFile();
    }

    public void saveResource(String resourcePath, boolean replace) {
        this.saveResource(resourcePath, this.dataFolder, replace, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File saveResource(String jarResource, File destinationFolder, boolean replace, boolean noPath) {
        if (jarResource == null) throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        if (jarResource.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        jarResource = jarResource.replace('\\', '/');
        try (JarFile jar = new JarFile(this.file);){
            JarEntry jarConfig = jar.getJarEntry(jarResource);
            if (jarConfig == null) throw new IllegalArgumentException("The embedded resource '" + jarResource + "' cannot be found in " + jar.getName());
            try (InputStream in = jar.getInputStream(jarConfig);){
                if (in == null) {
                    throw new IllegalArgumentException("The embedded resource '" + jarResource + "' cannot be found in " + jar.getName());
                }
                File outFile = new File(destinationFolder, jarResource.replaceAll("/", Matcher.quoteReplacement(File.separator)));
                if (noPath) {
                    outFile = new File(destinationFolder, outFile.getName());
                }
                outFile.getParentFile().mkdirs();
                if (!outFile.exists() || replace) {
                    Files.copy(in, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                File file = outFile;
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BentoBox.getInstance().logError("Could not save from jar file. From " + jarResource + " to " + destinationFolder.getAbsolutePath());
            return null;
        }
    }

    public YamlConfiguration getYamlFromJar(String jarResource) throws IOException, InvalidConfigurationException {
        YamlConfiguration result;
        block11: {
            if (jarResource == null || jarResource.isEmpty()) {
                throw new IllegalArgumentException("jarResource cannot be null or empty");
            }
            result = new YamlConfiguration();
            jarResource = jarResource.replace('\\', '/');
            try (JarFile jar = new JarFile(this.file);){
                JarEntry jarConfig = jar.getJarEntry(jarResource);
                if (jarConfig == null) break block11;
                try (InputStreamReader in = new InputStreamReader(jar.getInputStream(jarConfig));){
                    result.load((Reader)in);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public InputStream getResource(String jarResource) {
        block14: {
            if (jarResource == null || jarResource.isEmpty()) {
                throw new IllegalArgumentException("ResourcePath cannot be null or empty");
            }
            jarResource = jarResource.replace('\\', '/');
            try (JarFile jar = new JarFile(this.file);){
                InputStream inputStream;
                block15: {
                    JarEntry jarConfig = jar.getJarEntry(jarResource);
                    if (jarConfig == null) break block14;
                    InputStream in = jar.getInputStream(jarConfig);
                    try {
                        inputStream = in;
                        if (in == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return inputStream;
            }
            catch (IOException e) {
                BentoBox.getInstance().logError("Could not open from jar file. " + jarResource);
            }
        }
        return null;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void setDataFolder(File file) {
        this.dataFolder = file;
    }

    public void setDescription(AddonDescription description) {
        this.description = description;
    }

    public void setState(State state) {
        this.state = state;
    }

    public PlayersManager getPlayers() {
        return this.getPlugin().getPlayers();
    }

    public IslandsManager getIslands() {
        return this.getPlugin().getIslands();
    }

    public IslandsManager getIslandsManager() {
        return this.getPlugin().getIslandsManager();
    }

    public Optional<Addon> getAddonByName(String name) {
        return this.getPlugin().getAddonsManager().getAddonByName(name);
    }

    public void log(String string) {
        this.getPlugin().log((String)(this.getDescription() != null ? "[" + this.getDescription().getName() + "] " + string : string));
    }

    public void logWarning(String string) {
        this.getPlugin().logWarning((String)(this.getDescription() != null ? "[" + this.getDescription().getName() + "] " + string : string));
    }

    public void logError(String string) {
        this.getPlugin().logError((String)(this.getDescription() != null ? "[" + this.getDescription().getName() + "] " + string : string));
    }

    public String getPermissionPrefix() {
        return this.getDescription().getName().toLowerCase(Locale.ENGLISH) + ".";
    }

    public void registerRequestHandler(AddonRequestHandler handler) {
        this.requestHandlers.put(handler.getLabel(), handler);
    }

    public Object request(String label, Map<String, Object> metaData) {
        AddonRequestHandler handler = this.requestHandlers.get(label = label.toLowerCase(Locale.ENGLISH));
        if (handler != null) {
            return handler.handle(metaData);
        }
        return null;
    }

    public boolean registerFlag(Flag flag) {
        return this.getPlugin().getFlagsManager().registerFlag(this, flag);
    }

    public void allLoaded() {
    }

    public static enum State {
        LOADED,
        ENABLED,
        DISABLED,
        INCOMPATIBLE,
        MISSING_DEPENDENCY,
        ERROR;

    }
}

