/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.purge;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class AdminPurgeUnownedCommand
extends ConfirmableCommand {
    public AdminPurgeUnownedCommand(AdminPurgeCommand parent) {
        super(parent, "unowned", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.purge.unowned");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.purge.unowned.parameters");
        this.setDescription("commands.admin.purge.unowned.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        AdminPurgeCommand parentCommand = (AdminPurgeCommand)this.getParent();
        if (parentCommand.isInPurge()) {
            user.sendMessage("commands.admin.purge.purge-in-progress", "[label]", this.getTopLabel());
            return false;
        }
        Set<String> unowned = this.getUnownedIslands();
        user.sendMessage("commands.admin.purge.unowned.unowned-islands", "[number]", String.valueOf(unowned.size()));
        if (!unowned.isEmpty()) {
            this.askConfirmation(user, () -> {
                parentCommand.setUser(user);
                parentCommand.setIslands(unowned);
                parentCommand.removeIslands();
            });
        }
        return true;
    }

    Set<String> getUnownedIslands() {
        return this.getPlugin().getIslands().getIslands().stream().filter(i -> !i.isSpawn()).filter(i -> !i.isPurgeProtected()).filter(i -> i.getWorld().equals((Object)this.getWorld())).filter(Island::isUnowned).map(Island::getUniqueId).collect(Collectors.toSet());
    }
}

