/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.team;

import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminTeamKickCommand
extends CompositeCommand {
    private @Nullable UUID targetUUID;

    public AdminTeamKickCommand(CompositeCommand parent) {
        super(parent, "kick", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.team.kick");
        this.setParametersHelp("commands.admin.team.kick.parameters");
        this.setDescription("commands.admin.team.kick.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (!this.getIslands().inTeam(this.getWorld(), this.targetUUID)) {
            user.sendMessage("commands.admin.team.kick.not-in-team", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, @NonNull List<String> args) {
        List<Island> islands = this.getIslands().getIslands(this.getWorld(), this.targetUUID);
        if (islands.isEmpty()) {
            return false;
        }
        islands.forEach(island -> {
            if (!user.getUniqueId().equals(island.getOwner())) {
                assert (this.targetUUID != null);
                User target = User.getInstance(this.targetUUID);
                target.sendMessage("commands.admin.team.kick.admin-kicked", new String[0]);
                this.getIslands().removePlayer((Island)island, this.targetUUID);
                user.sendMessage("commands.admin.team.kick.success", "[name]", target.getName(), "[owner]", this.getPlayers().getName(island.getOwner()));
                TeamEvent.builder().island((Island)island).reason(TeamEvent.Reason.KICK).involvedPlayer(this.targetUUID).admin(true).build();
                IslandEvent.builder().island((Island)island).involvedPlayer(this.targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(island.getRank(target), 0).build();
            }
        });
        user.sendMessage("commands.admin.team.kick.success-all", new String[0]);
        return true;
    }
}

