/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.DelayedTeleportCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;

public class IslandSpawnCommand
extends DelayedTeleportCommand {
    public IslandSpawnCommand(CompositeCommand parent) {
        super(parent, "spawn", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.spawn");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.spawn.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.getIWM().inWorld(user.getWorld()) && Flags.PREVENT_TELEPORT_WHEN_FALLING.isSetForWorld(user.getWorld()) && user.getPlayer().getFallDistance() > 0.0f) {
            user.sendMessage(Flags.PREVENT_TELEPORT_WHEN_FALLING.getHintReference(), new String[0]);
            return false;
        }
        this.delayCommand(user, () -> this.getIslands().spawnTeleport(this.getWorld(), user.getPlayer()));
        return true;
    }
}

