/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Material;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;

public class FlagTypeAdapter
extends TypeAdapter<Flag> {
    private final BentoBox plugin;

    public FlagTypeAdapter(BentoBox plugin) {
        this.plugin = plugin;
    }

    public void write(JsonWriter out, Flag value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.getID());
    }

    public Flag read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String id = reader.nextString();
        Flag f = this.plugin.getFlagsManager().getFlag(id).orElse(null);
        if (f == null) {
            f = new Flag.Builder("NULL_FLAG_" + String.valueOf(UUID.randomUUID()), Material.STONE).build();
        }
        return f;
    }
}

