/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql.postgresql;

import com.zaxxer.hikari.HikariConfig;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.database.DatabaseConnectionSettingsImpl;
import world.bentobox.bentobox.database.sql.SQLDatabaseConnector;

public class PostgreSQLDatabaseConnector
extends SQLDatabaseConnector {
    PostgreSQLDatabaseConnector(@NonNull DatabaseConnectionSettingsImpl dbSettings) {
        super(dbSettings, "");
    }

    @Override
    public HikariConfig createConfig() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("BentoBox PostgreSQL Pool");
        config.setDataSourceClassName("org.postgresql.ds.PGSimpleDataSource");
        config.addDataSourceProperty("user", (Object)this.dbSettings.getUsername());
        config.addDataSourceProperty("password", (Object)this.dbSettings.getPassword());
        config.addDataSourceProperty("databaseName", (Object)this.dbSettings.getDatabaseName());
        config.addDataSourceProperty("serverName", (Object)this.dbSettings.getHost());
        config.addDataSourceProperty("portNumber", (Object)this.dbSettings.getPort());
        config.addDataSourceProperty("ssl", (Object)this.dbSettings.isUseSSL());
        this.dbSettings.getExtraProperties().forEach((arg_0, arg_1) -> ((HikariConfig)config).addDataSourceProperty(arg_0, arg_1));
        config.setMaximumPoolSize(this.dbSettings.getMaxConnections());
        return config;
    }
}

