/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.actions.ActionTrigger;
import de.oliver.fancynpcs.api.actions.NpcAction;
import de.oliver.fancynpcs.api.utils.NpcEquipmentSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.NPCHook;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;

public class FancyNpcsHook
extends NPCHook {
    public FancyNpcsHook() {
        super("FancyNpcs", Material.PLAYER_HEAD);
    }

    String serializeNPC(Npc npc, Vector origin) {
        if (npc == null) {
            throw new IllegalArgumentException("NPC cannot be null.");
        }
        YamlConfiguration npcConfig = new YamlConfiguration();
        NpcData data = npc.getData();
        npcConfig.set("name", (Object)data.getName());
        npcConfig.set("creator", (Object)data.getCreator().toString());
        npcConfig.set("displayName", (Object)data.getDisplayName());
        npcConfig.set("type", (Object)data.getType().name());
        npcConfig.set("location.world", (Object)data.getLocation().getWorld().getName());
        npcConfig.set("location.x", (Object)(data.getLocation().getX() - (double)origin.getBlockX()));
        npcConfig.set("location.y", (Object)(data.getLocation().getY() - (double)origin.getBlockY()));
        npcConfig.set("location.z", (Object)(data.getLocation().getZ() - (double)origin.getBlockZ()));
        npcConfig.set("location.yaw", (Object)Float.valueOf(data.getLocation().getYaw()));
        npcConfig.set("location.pitch", (Object)Float.valueOf(data.getLocation().getPitch()));
        npcConfig.set("showInTab", (Object)data.isShowInTab());
        npcConfig.set("spawnEntity", (Object)data.isSpawnEntity());
        npcConfig.set("collidable", (Object)data.isCollidable());
        npcConfig.set("glowing", (Object)data.isGlowing());
        npcConfig.set("glowingColor", (Object)data.getGlowingColor().toString());
        npcConfig.set("turnToPlayer", (Object)data.isTurnToPlayer());
        npcConfig.set("messages", null);
        npcConfig.set("playerCommands", null);
        npcConfig.set("serverCommands", null);
        npcConfig.set("sendMessagesRandomly", null);
        npcConfig.set("interactionCooldown", (Object)Float.valueOf(data.getInteractionCooldown()));
        npcConfig.set("scale", (Object)Float.valueOf(data.getScale()));
        if (data.getSkinData() != null) {
            npcConfig.set("skin.identifier", (Object)data.getSkinData().getIdentifier());
        } else {
            npcConfig.set("skin.identifier", null);
        }
        npcConfig.set("skin.mirrorSkin", (Object)data.isMirrorSkin());
        if (data.getEquipment() != null) {
            for (Map.Entry entry : data.getEquipment().entrySet()) {
                npcConfig.set("equipment." + ((NpcEquipmentSlot)entry.getKey()).name(), entry.getValue());
            }
        }
        for (NpcAttribute attribute : FancyNpcsPlugin.get().getAttributeManager().getAllAttributesForEntityType(data.getType())) {
            String value = data.getAttributes().getOrDefault(attribute, null);
            npcConfig.set("attributes." + attribute.getName(), (Object)value);
        }
        npcConfig.set("actions", null);
        for (Map.Entry entry : npc.getData().getActions().entrySet()) {
            for (NpcAction.NpcActionData actionData : (List)entry.getValue()) {
                if (actionData == null) continue;
                npcConfig.set("actions." + ((ActionTrigger)entry.getKey()).name() + "." + actionData.order() + ".action", (Object)actionData.action().getName());
                npcConfig.set("actions." + ((ActionTrigger)entry.getKey()).name() + "." + actionData.order() + ".value", (Object)actionData.value());
            }
        }
        return npcConfig.saveToString();
    }

    @Override
    public boolean spawnNpc(String yaml, Location pos) throws InvalidConfigurationException {
        YamlConfiguration npcConfig = new YamlConfiguration();
        npcConfig.loadFromString(yaml);
        String name = UUID.randomUUID().toString();
        UUID creator = UUID.randomUUID();
        String displayName = npcConfig.getString("displayName", "<empty>");
        EntityType type = EntityType.valueOf((String)npcConfig.getString("type", "PLAYER").toUpperCase(Locale.ENGLISH));
        double x = pos.getBlockX();
        double y = pos.getBlockY();
        double z = pos.getBlockZ();
        float yaw = (float)npcConfig.getDouble("location.yaw");
        float pitch = (float)npcConfig.getDouble("location.pitch");
        Location location = new Location(pos.getWorld(), x, y, z, yaw, pitch);
        String skinIdentifier = npcConfig.getString("skin.identifier", npcConfig.getString("skin.uuid", ""));
        boolean mirrorSkin = npcConfig.getBoolean("skin.mirrorSkin");
        boolean showInTab = npcConfig.getBoolean("showInTab");
        boolean spawnEntity = npcConfig.getBoolean("spawnEntity");
        boolean collidable = npcConfig.getBoolean("collidable", true);
        boolean glowing = npcConfig.getBoolean("glowing");
        NamedTextColor glowingColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)npcConfig.getString("glowingColor", "white"));
        boolean turnToPlayer = npcConfig.getBoolean("turnToPlayer");
        ConcurrentHashMap actions = new ConcurrentHashMap();
        ConfigurationSection actiontriggerSection = npcConfig.getConfigurationSection("actions");
        if (actiontriggerSection != null) {
            actiontriggerSection.getKeys(false).forEach(trigger -> {
                ActionTrigger actionTrigger = ActionTrigger.getByName((String)trigger);
                if (actionTrigger == null) {
                    BentoBox.getInstance().logWarning("Could not find action trigger: " + trigger);
                    return;
                }
                ArrayList actionList = new ArrayList();
                ConfigurationSection actionsSection = npcConfig.getConfigurationSection("actions." + trigger);
                if (actionsSection != null) {
                    actionsSection.getKeys(false).forEach(order -> {
                        String actionName = npcConfig.getString("actions." + trigger + "." + order + ".action");
                        String value = npcConfig.getString("actions." + trigger + "." + order + ".value");
                        NpcAction action = FancyNpcsPlugin.get().getActionManager().getActionByName(actionName);
                        if (action == null) {
                            BentoBox.getInstance().logWarning("Could not find action: " + actionName);
                            return;
                        }
                        try {
                            actionList.add(new NpcAction.NpcActionData(Integer.parseInt(order), action, value));
                        }
                        catch (NumberFormatException e) {
                            BentoBox.getInstance().logWarning("Could not parse order: " + order);
                        }
                    });
                    actions.put(actionTrigger, actionList);
                }
            });
        }
        float interactionCooldown = (float)npcConfig.getDouble("interactionCooldown", 0.0);
        float scale = (float)npcConfig.getDouble("scale", 1.0);
        HashMap<NpcAttribute, String> attributes = new HashMap<NpcAttribute, String>();
        if (npcConfig.isConfigurationSection("attributes")) {
            for (String attrName : npcConfig.getConfigurationSection("attributes").getKeys(false)) {
                NpcAttribute attribute = FancyNpcsPlugin.get().getAttributeManager().getAttributeByName(type, attrName);
                if (attribute == null) {
                    BentoBox.getInstance().logWarning("Could not find attribute: " + attrName);
                    continue;
                }
                String value = npcConfig.getString("attributes." + attrName);
                if (!attribute.isValidValue(value)) {
                    BentoBox.getInstance().logWarning("Invalid value for attribute: " + attrName);
                    continue;
                }
                attributes.put(attribute, value);
            }
        }
        FancyNpcsPlugin.get().getNpcManager().getNpc(name);
        String newId = UUID.randomUUID().toString();
        NpcData data = new NpcData(newId, creator, location).setDisplayName(displayName).setSkin(skinIdentifier).setLocation(location).setShowInTab(showInTab).setSpawnEntity(spawnEntity).setCollidable(collidable).setGlowing(glowing).setGlowingColor(glowingColor).setType(type).setTurnToPlayer(turnToPlayer).setActions(actions).setInteractionCooldown(interactionCooldown).setScale(scale).setMirrorSkin(mirrorSkin);
        attributes.forEach((arg_0, arg_1) -> ((NpcData)data).addAttribute(arg_0, arg_1));
        Npc npc = (Npc)FancyNpcsPlugin.get().getNpcAdapter().apply(data);
        if (npcConfig.isConfigurationSection("equipment")) {
            for (String equipmentSlotStr : npcConfig.getConfigurationSection("equipment").getKeys(false)) {
                NpcEquipmentSlot equipmentSlot = NpcEquipmentSlot.parse((String)equipmentSlotStr);
                ItemStack item = npcConfig.getItemStack("equipment." + equipmentSlotStr);
                npc.getData().addEquipment(equipmentSlot, item);
            }
        }
        Bukkit.getScheduler().runTask(this.getPlugin(), () -> {
            FancyNpcsPlugin.get().getNpcManager().registerNpc(npc);
            npc.create();
            npc.spawnForAll();
        });
        return true;
    }

    @Override
    public boolean hook() {
        boolean hooked = this.isPluginAvailable();
        if (!hooked) {
            BentoBox.getInstance().logError("Could not hook into FancyNpcs");
        }
        return hooked;
    }

    @Override
    public String getFailureCause() {
        return null;
    }

    public List<Npc> getNPCsInChunk(Chunk chunk) {
        return FancyNpcsPlugin.get().getNpcManager().getAllNpcs().stream().filter(npc -> npc.getData().getLocation().getChunk().equals((Object)chunk)).toList();
    }

    @Override
    public void removeNPCsInChunk(Chunk chunk) {
        this.getNPCsInChunk(chunk).forEach(Npc::removeForAll);
    }

    @Override
    public Map<? extends Vector, ? extends List<BlueprintEntity>> getNpcsInArea(World world, List<Vector> vectorsToCopy, @Nullable Vector origin) {
        HashMap<Vector, List> bpEntities = new HashMap<Vector, List>();
        for (Npc npc : FancyNpcsPlugin.get().getNpcManager().getAllNpcs()) {
            Location npcLocation = npc.getData().getLocation();
            Vector spot = new Vector(npcLocation.getBlockX(), npcLocation.getBlockY(), npcLocation.getBlockZ());
            if (!npcLocation.getWorld().equals((Object)world) || !vectorsToCopy.contains(spot)) continue;
            BlueprintEntity cit = new BlueprintEntity();
            cit.setType(npc.getData().getType());
            cit.setNpc(this.serializeNPC(npc, origin));
            List entities = bpEntities.getOrDefault(spot, new ArrayList());
            entities.add(cit);
            Vector origin2 = origin == null ? new Vector(0, 0, 0) : origin;
            int x = spot.getBlockX() - origin2.getBlockX();
            int y = spot.getBlockY() - origin2.getBlockY();
            int z = spot.getBlockZ() - origin2.getBlockZ();
            Vector pos = new Vector(x, y, z);
            bpEntities.put(pos, entities);
        }
        return bpEntities;
    }
}

