/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.clicklisteners;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TabbedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.listeners.flags.clicklisteners.CommandCycleClick;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.panels.settings.SettingsTab;
import world.bentobox.bentobox.util.Util;

public class CommandRankClickListener
implements PanelItem.ClickHandler {
    private final BentoBox plugin = BentoBox.getInstance();
    private Island island;

    @Override
    public boolean onClick(Panel panel, User user, ClickType clickType, int slot) {
        TabbedPanel tp = (TabbedPanel)panel;
        SettingsTab st = (SettingsTab)tp.getActiveTab();
        this.island = st.getIsland();
        if (!user.inWorld()) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return true;
        }
        World w = Objects.requireNonNull(Util.getWorld(panel.getWorld().orElse(user.getWorld())));
        String prefix = this.plugin.getIWM().getPermissionPrefix(w);
        String reqPerm = prefix + "settings." + Flags.COMMAND_RANKS.getID();
        String allPerms = prefix + "settings.*";
        if (!(user.hasPermission(reqPerm) || user.hasPermission(allPerms) || user.isOp() || user.hasPermission(prefix + "admin.settings"))) {
            user.sendMessage("general.errors.no-permission", "[permission]", reqPerm);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        if (!this.island.isAllowed(user, Flags.CHANGE_SETTINGS)) {
            String rank = user.getTranslation(RanksManager.getInstance().getRank(Objects.requireNonNull(this.island).getRank(user)), new String[0]);
            user.sendMessage("general.errors.insufficient-rank", "[rank]", rank);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        String panelName = user.getTranslation("protection.flags.COMMAND_RANKS.name", new String[0]);
        if (panel.getName().equals(panelName)) {
            if (this.plugin.onTimeout(user, panel)) {
                return true;
            }
            String c = this.getCommands(panel.getWorld().orElse(user.getWorld()), user).get(slot);
            panel.getInventory().setItem(slot, this.getPanelItem(c, user, panel.getWorld().orElse(user.getWorld())).getItem());
        } else {
            this.openPanel(user, panelName, panel.getWorld().orElse(user.getWorld()));
        }
        return true;
    }

    private void openPanel(User user, String panelName, World world) {
        user.closeInventory();
        PanelBuilder pb = new PanelBuilder();
        pb.user(user).name(panelName).world(world);
        this.getCommands(world, user).forEach(c -> pb.item(this.getPanelItem((String)c, user, world)));
        Panel p = pb.build();
        p.setIsland(this.island);
    }

    public PanelItem getPanelItem(String c, User user, World world) {
        PanelItemBuilder pib = new PanelItemBuilder();
        pib.name(user.getTranslation("protection.panel.flag-item.name-layout", "[name]", c));
        pib.clickHandler(new CommandCycleClick(this, c));
        pib.icon(Material.MAP);
        String result = "";
        String[] words = c.split(" ", 2);
        if (words.length > 1) {
            result = words[1].replace(" ", "-");
        }
        String ref = "protection.panel.flag-item.command-instructions." + result.toLowerCase(Locale.ENGLISH);
        String commandDescription = user.getTranslationOrNothing(ref, new String[0]);
        String d = user.getTranslation("protection.panel.flag-item.description-layout", "[description]", commandDescription);
        pib.description(d);
        RanksManager.getInstance().getRanks().forEach((reference, score) -> {
            if (score >= 500 && score < this.island.getRankCommand(c)) {
                pib.description(user.getTranslation("protection.panel.flag-item.blocked-rank", new String[0]) + user.getTranslation((String)reference, new String[0]));
            } else if (score <= 1000 && score > this.island.getRankCommand(c)) {
                pib.description(user.getTranslation("protection.panel.flag-item.allowed-rank", new String[0]) + user.getTranslation((String)reference, new String[0]));
            } else if (score.intValue() == this.island.getRankCommand(c)) {
                pib.description(user.getTranslation("protection.panel.flag-item.minimal-rank", new String[0]) + user.getTranslation((String)reference, new String[0]));
            }
        });
        pib.invisible(this.plugin.getIWM().getHiddenFlags(world).contains("COMMAND_RANK:" + c));
        return pib.build();
    }

    private List<String> getCommands(World world, User user) {
        List<String> hiddenItems = this.plugin.getIWM().getHiddenFlags(world);
        return this.plugin.getCommandsManager().getCommands().values().stream().filter(c -> c.getWorld() != null && c.getWorld().equals((Object)world)).filter(c -> c.testPermission(user.getSender())).flatMap(c -> this.getCmdRecursively("/", (CompositeCommand)c).stream()).filter(label -> user.isOp() || !hiddenItems.contains("COMMAND_RANK:" + label)).limit(49L).toList();
    }

    private List<String> getCmdRecursively(String labels, CompositeCommand cc) {
        ArrayList<String> result = new ArrayList<String>();
        String newLabel = labels + cc.getName();
        if (cc.isConfigurableRankCommand()) {
            result.add(newLabel);
        }
        cc.getSubCommands().values().forEach(s -> result.addAll(this.getCmdRecursively(newLabel + " ", (CompositeCommand)s)));
        return result;
    }
}

