/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Fish;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;

public class BucketListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent e) {
        Block dumpBlock = e.getBlockClicked().getRelative(e.getBlockFace());
        this.checkIsland((Event)e, e.getPlayer(), dumpBlock.getLocation(), Flags.BUCKET);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBucketFill(PlayerBucketFillEvent e) {
        Player p = e.getPlayer();
        Location l = e.getBlockClicked().getLocation();
        if (e.getItemStack() == null) {
            return;
        }
        switch (e.getItemStack().getType()) {
            case LAVA_BUCKET: {
                this.checkIsland((Event)e, p, l, Flags.COLLECT_LAVA);
                break;
            }
            case WATER_BUCKET: {
                this.checkIsland((Event)e, p, l, Flags.COLLECT_WATER);
                break;
            }
            case POWDER_SNOW_BUCKET: {
                this.checkIsland((Event)e, p, l, Flags.COLLECT_POWDERED_SNOW);
                break;
            }
            case MILK_BUCKET: {
                this.checkIsland((Event)e, p, l, Flags.MILKING);
                break;
            }
            default: {
                this.checkIsland((Event)e, p, l, Flags.BUCKET);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onTropicalFishScooping(PlayerInteractEntityEvent e) {
        if (e.getRightClicked() instanceof Fish && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.WATER_BUCKET)) {
            this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.FISH_SCOOPING);
        } else if (e.getRightClicked() instanceof Axolotl && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.WATER_BUCKET)) {
            this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.AXOLOTL_SCOOPING);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBowlFill(PlayerInteractEntityEvent e) {
        if (e.getRightClicked() instanceof MushroomCow && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.BOWL)) {
            this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.MILKING);
        }
    }
}

