/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.github.GitHubWebAPI;
import world.bentobox.bentobox.api.github.objects.repositories.GitHubContributor;
import world.bentobox.bentobox.api.github.objects.repositories.GitHubRepository;
import world.bentobox.bentobox.web.catalog.CatalogEntry;
import world.bentobox.bentobox.web.credits.Contributor;

public class WebManager {
    private final @NonNull BentoBox plugin;
    private @Nullable GitHubWebAPI gitHub;
    private final @NonNull List<CatalogEntry> addonsCatalog;
    private final @NonNull List<CatalogEntry> gamemodesCatalog;
    private final @NonNull Map<String, List<Contributor>> contributors;

    public WebManager(@NonNull BentoBox plugin) {
        this.plugin = plugin;
        this.addonsCatalog = new ArrayList<CatalogEntry>();
        this.gamemodesCatalog = new ArrayList<CatalogEntry>();
        this.contributors = new HashMap<String, List<Contributor>>();
        if (plugin.getSettings().isGithubDownloadData()) {
            this.gitHub = new GitHubWebAPI();
            long connectionInterval = (long)plugin.getSettings().getGithubConnectionInterval() * 20L * 60L;
            if (connectionInterval <= 0L) {
                plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)plugin, this::requestGitHubData, 20L);
            } else {
                connectionInterval = Math.max(connectionInterval, 72000L);
                plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::requestGitHubData, 20L, connectionInterval);
            }
        }
    }

    public void requestGitHubData() {
        this.getGitHub().ifPresent(gh -> {
            GitHubRepository weblinkRepo;
            if (this.plugin.getSettings().isLogGithubDownloadData()) {
                this.plugin.log("Downloading data from GitHub...");
                this.plugin.log("Updating the Catalog...");
            }
            try {
                weblinkRepo = new GitHubRepository((GitHubWebAPI)gh, "BentoBoxWorld/weblink");
            }
            catch (Exception e) {
                if (this.plugin.getSettings().isLogGithubDownloadData()) {
                    this.plugin.logError("An unhandled exception occurred when connecting to the GitHub weblink..");
                    this.plugin.logStacktrace(e);
                }
                weblinkRepo = null;
            }
            if (weblinkRepo != null) {
                String tagsContent = this.getContent(weblinkRepo, "catalog/tags.json");
                String topicsContent = this.getContent(weblinkRepo, "catalog/topics.json");
                String catalogContent = this.getContent(weblinkRepo, "catalog/catalog.json");
                this.parseCatalogContent(tagsContent, topicsContent, catalogContent);
            }
            if (this.plugin.getSettings().isLogGithubDownloadData()) {
                this.plugin.log("Updating Contributors information...");
            }
            ArrayList<String> repositories = new ArrayList<String>();
            repositories.add("BentoBoxWorld/BentoBox");
            repositories.addAll(this.plugin.getAddonsManager().getEnabledAddons().stream().map(addon -> addon.getDescription().getRepository()).filter(repo -> !repo.isEmpty()).toList());
            if (this.plugin.getSettings().isLogGithubDownloadData()) {
                this.plugin.log("Gathering contribution data for: " + String.join((CharSequence)", ", repositories));
            }
            for (String repository : repositories) {
                GitHubRepository repo2;
                try {
                    repo2 = new GitHubRepository((GitHubWebAPI)gh, repository);
                }
                catch (Exception e) {
                    if (this.plugin.getSettings().isLogGithubDownloadData()) {
                        this.plugin.logError("An unhandled exception occurred when gathering contributors data from the '" + repository + "' repository...");
                        this.plugin.logStacktrace(e);
                    }
                    repo2 = null;
                }
                if (repo2 == null) continue;
                this.gatherContributors(repo2);
            }
            if (this.plugin.getSettings().isLogGithubDownloadData()) {
                this.plugin.log("Successfully downloaded data from GitHub.");
            }
        });
    }

    private void parseCatalogContent(String tagsContent, String topicsContent, String catalogContent) {
        block11: {
            block10: {
                block9: {
                    if (!tagsContent.isEmpty()) {
                        try {
                            JsonObject tags = JsonParser.parseString((String)tagsContent).getAsJsonObject();
                            tags.entrySet().forEach(entry -> this.plugin.getLocalesManager().getLanguages().values().forEach(locale -> {
                                JsonElement translation = ((JsonElement)entry.getValue()).getAsJsonObject().get(locale.toLanguageTag());
                                if (translation != null) {
                                    locale.set("catalog.tags." + (String)entry.getKey(), translation.getAsString());
                                }
                            }));
                        }
                        catch (JsonParseException e) {
                            if (!this.plugin.getSettings().isLogGithubDownloadData()) break block9;
                            this.plugin.log("Could not update the Catalog Tags: the gathered JSON data is malformed.");
                        }
                    }
                }
                if (!topicsContent.isEmpty()) {
                    try {
                        JsonObject topics = JsonParser.parseString((String)topicsContent).getAsJsonObject();
                        topics.entrySet().forEach(entry -> this.plugin.getLocalesManager().getLanguages().values().forEach(locale -> {
                            JsonElement translation = ((JsonElement)entry.getValue()).getAsJsonObject().get(locale.toLanguageTag());
                            if (translation != null) {
                                locale.set("catalog.topics." + (String)entry.getKey(), translation.getAsString());
                            }
                        }));
                    }
                    catch (JsonParseException e) {
                        if (!this.plugin.getSettings().isLogGithubDownloadData()) break block10;
                        this.plugin.log("Could not update the Catalog Topics: the gathered JSON data is malformed.");
                    }
                }
            }
            if (!catalogContent.isEmpty()) {
                try {
                    JsonObject catalog = JsonParser.parseString((String)catalogContent).getAsJsonObject();
                    this.addonsCatalog.clear();
                    this.gamemodesCatalog.clear();
                    catalog.getAsJsonArray("gamemodes").forEach(gamemode -> this.gamemodesCatalog.add(new CatalogEntry(gamemode.getAsJsonObject())));
                    catalog.getAsJsonArray("addons").forEach(addon -> this.addonsCatalog.add(new CatalogEntry(addon.getAsJsonObject())));
                }
                catch (JsonParseException e) {
                    if (!this.plugin.getSettings().isLogGithubDownloadData()) break block11;
                    this.plugin.log("Could not update the Catalog content: the gathered JSON data is malformed.");
                }
            }
        }
    }

    private @NonNull String getContent(@NonNull GitHubRepository repo, String fileName) {
        try {
            String content = repo.getContent(fileName).getContent();
            return new String(DatatypeConverter.parseBase64Binary(content.replaceAll("_", "/")));
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void gatherContributors(@NonNull GitHubRepository repo) {
        try {
            LinkedList<Contributor> addonContributors = new LinkedList<Contributor>();
            for (GitHubContributor gitHubContributor : repo.getContributors()) {
                addonContributors.add(new Contributor(gitHubContributor.username(), gitHubContributor.contributionsAmount()));
            }
            this.contributors.put(repo.fullName(), addonContributors);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public @NonNull List<CatalogEntry> getAddonsCatalog() {
        return this.addonsCatalog;
    }

    public @NonNull List<CatalogEntry> getGamemodesCatalog() {
        return this.gamemodesCatalog;
    }

    public @NonNull List<Contributor> getContributors(String repository) {
        return this.contributors.getOrDefault(repository, new ArrayList());
    }

    public @NonNull Optional<GitHubWebAPI> getGitHub() {
        return Optional.ofNullable(this.gitHub);
    }
}

