/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers.island;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.managers.island.NewIslandLocationStrategy;
import world.bentobox.bentobox.util.Util;

public class DefaultNewIslandLocationStrategy
implements NewIslandLocationStrategy {
    protected static final Integer MAX_UNOWNED_ISLANDS = 20;
    protected final BentoBox plugin = BentoBox.getInstance();

    @Override
    public Location getNextLocation(World world) {
        Location last = this.plugin.getIslands().getLast(world);
        if (last == null) {
            last = new Location(world, (double)this.plugin.getIWM().getIslandXOffset(world) + (double)this.plugin.getIWM().getIslandStartX(world), (double)this.plugin.getIWM().getIslandHeight(world), (double)this.plugin.getIWM().getIslandZOffset(world) + (double)this.plugin.getIWM().getIslandStartZ(world));
        }
        EnumMap<Result, Integer> result = new EnumMap<Result, Integer>(Result.class);
        Result r = this.isIsland(last);
        while (!r.equals((Object)Result.FREE) && result.getOrDefault((Object)Result.BLOCKS_IN_AREA, 0) < MAX_UNOWNED_ISLANDS) {
            this.nextGridLocation(last);
            result.put(r, result.getOrDefault((Object)r, 0) + 1);
            r = this.isIsland(last);
        }
        if (!r.equals((Object)Result.FREE)) {
            this.plugin.logError("Could not find a free spot for islands! Is this world empty?");
            this.plugin.logError("Blocks around center locations: " + String.valueOf(result.getOrDefault((Object)Result.BLOCKS_IN_AREA, 0)) + " max " + MAX_UNOWNED_ISLANDS);
            this.plugin.logError("Known islands: " + String.valueOf(result.getOrDefault((Object)Result.ISLAND_FOUND, 0)) + " max unlimited.");
            return null;
        }
        this.plugin.getIslands().setLast(last);
        return last;
    }

    protected Result isIsland(Location location) {
        if (this.plugin.getIslands().isIslandAt(location)) {
            return Result.ISLAND_FOUND;
        }
        World world = location.getWorld();
        int dist = this.plugin.getIWM().getIslandDistance(location.getWorld());
        HashSet<Location> locs = new HashSet<Location>();
        locs.add(location);
        locs.add(new Location(world, location.getX() - (double)dist, 0.0, location.getZ() - (double)dist));
        locs.add(new Location(world, location.getX() - (double)dist, 0.0, location.getZ() + (double)dist - 1.0));
        locs.add(new Location(world, location.getX() + (double)dist - 1.0, 0.0, location.getZ() - (double)dist));
        locs.add(new Location(world, location.getX() + (double)dist - 1.0, 0.0, location.getZ() + (double)dist - 1.0));
        boolean generated = false;
        for (Location l : locs) {
            if (this.plugin.getIslands().getIslandAt(l).isPresent() || this.plugin.getIslandDeletionManager().inDeletion(l)) {
                return Result.ISLAND_FOUND;
            }
            if (!Util.isChunkGenerated(l)) continue;
            generated = true;
        }
        if (!generated) {
            return Result.FREE;
        }
        if (this.plugin.getIWM().isCheckForBlocks(world) && !this.plugin.getIWM().isUseOwnGenerator(world) && Arrays.stream(BlockFace.values()).anyMatch(bf -> !location.getBlock().getRelative(bf).isEmpty() && !location.getBlock().getRelative(bf).getType().equals((Object)Material.WATER))) {
            this.plugin.getIslands().createIsland(location);
            return Result.BLOCKS_IN_AREA;
        }
        return Result.FREE;
    }

    private Location nextGridLocation(Location lastIsland) {
        int x = lastIsland.getBlockX();
        int z = lastIsland.getBlockZ();
        int d = this.plugin.getIWM().getIslandDistance(lastIsland.getWorld()) * 2;
        if (x < z) {
            if (-1 * x < z) {
                lastIsland.setX(lastIsland.getX() + (double)d);
                return lastIsland;
            }
            lastIsland.setZ(lastIsland.getZ() + (double)d);
            return lastIsland;
        }
        if (x > z) {
            if (-1 * x >= z) {
                lastIsland.setX(lastIsland.getX() - (double)d);
                return lastIsland;
            }
            lastIsland.setZ(lastIsland.getZ() - (double)d);
            return lastIsland;
        }
        if (x <= 0) {
            lastIsland.setZ(lastIsland.getZ() + (double)d);
            return lastIsland;
        }
        lastIsland.setZ(lastIsland.getZ() - (double)d);
        return lastIsland;
    }

    protected static enum Result {
        ISLAND_FOUND,
        BLOCKS_IN_AREA,
        FREE;

    }
}

